/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.door;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class TrapdoorConnectionPredicate
implements ConnectionPredicate {
    public static final TrapdoorConnectionPredicate INSTANCE = new TrapdoorConnectionPredicate();

    private TrapdoorConnectionPredicate() {
    }

    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        if (open && ((Boolean)state.getValue((Property)PropertyHolder.ROTATE_TEXTURE)).booleanValue()) {
            return false;
        }
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        Direction fullFace = facing.getOpposite();
        if (!open) {
            Half half = (Half)state.getValue((Property)BlockStateProperties.HALF);
            Direction direction = fullFace = half == Half.BOTTOM ? Direction.DOWN : Direction.UP;
        }
        if (side == fullFace) {
            return true;
        }
        if (side.getAxis() != fullFace.getAxis()) {
            return edge == fullFace;
        }
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        boolean open = (Boolean)state.getValue((Property)BlockStateProperties.OPEN);
        if (open && ((Boolean)state.getValue((Property)PropertyHolder.ROTATE_TEXTURE)).booleanValue()) {
            return false;
        }
        Direction fullFace = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!open) {
            Half half = (Half)state.getValue((Property)BlockStateProperties.HALF);
            Direction direction = fullFace = half == Half.BOTTOM ? Direction.UP : Direction.DOWN;
        }
        if (side == fullFace) {
            return true;
        }
        if (side.getAxis() != fullFace.getAxis()) {
            return edge == fullFace.getOpposite() || edge.getAxis() != fullFace.getAxis();
        }
        return false;
    }
}

