/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.jei.camo;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.compat.jei.JeiConstants;
import xfacthd.framedblocks.common.compat.jei.camo.CamoCraftingHelper;
import xfacthd.framedblocks.common.compat.jei.camo.CamoItemStackHelper;
import xfacthd.framedblocks.common.compat.jei.camo.JeiCamoApplicationRecipe;

public final class CamoRecipeManagerPlugin
implements ISimpleRecipeManagerPlugin<RecipeHolder<CraftingRecipe>> {
    private final CamoCraftingHelper camoCraftingHelper;

    public CamoRecipeManagerPlugin(CamoCraftingHelper camoCraftingHelper) {
        this.camoCraftingHelper = camoCraftingHelper;
    }

    public boolean isHandledInput(ITypedIngredient<?> ingredient) {
        ItemStack itemStack = ingredient.getItemStack().orElse(ItemStack.EMPTY);
        if (CamoItemStackHelper.isEmptyFramedBlock(itemStack)) {
            return true;
        }
        if (this.camoCraftingHelper.getCopyToolIngredient().test(itemStack)) {
            return true;
        }
        return CamoItemStackHelper.getCamoContainerFactory(itemStack) != null;
    }

    public boolean isHandledOutput(ITypedIngredient<?> ingredient) {
        ItemStack itemStack = ingredient.getItemStack().orElse(ItemStack.EMPTY);
        IFramedBlock framedBlock = CamoItemStackHelper.getFramedBlock(itemStack);
        if (framedBlock != null) {
            int camoCount = CamoItemStackHelper.dropCamo(itemStack).size();
            return camoCount > 0 && camoCount <= 2;
        }
        return false;
    }

    public List<RecipeHolder<CraftingRecipe>> getRecipesForInput(ITypedIngredient<?> ingredient) {
        ItemStack itemStack = ingredient.getItemStack().orElse(ItemStack.EMPTY);
        if (CamoItemStackHelper.isEmptyFramedBlock(itemStack)) {
            RecipeHolder<CraftingRecipe> recipe = this.createRecipeForFrame(itemStack, (Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG));
            return List.of(recipe);
        }
        if (this.camoCraftingHelper.getCopyToolIngredient().test(itemStack)) {
            return this.createRecipesForEachFrame(this.camoCraftingHelper.getEmptyFramedBlocks(), (Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG));
        }
        CamoContainerFactory<?> containerFactory = CamoItemStackHelper.getCamoContainerFactory(itemStack);
        if (containerFactory != null) {
            RecipeHolder<CraftingRecipe> singleFrameRecipe = this.createRecipe((Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.ALL_FRAMES_TAG), (Either<ItemStack, TagKey<Item>>)Either.left((Object)itemStack), (Either<ItemStack, TagKey<Item>>)Either.left((Object)ItemStack.EMPTY), List.of());
            RecipeHolder<CraftingRecipe> doubleFrameRecipe = this.createRecipe((Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.DOUBLE_FRAMES_TAG), (Either<ItemStack, TagKey<Item>>)Either.left((Object)itemStack), (Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG), List.of());
            return List.of(singleFrameRecipe, doubleFrameRecipe);
        }
        return List.of();
    }

    public List<RecipeHolder<CraftingRecipe>> getRecipesForOutput(ITypedIngredient<?> ingredient) {
        ItemStack itemStack = ingredient.getItemStack().orElse(ItemStack.EMPTY);
        IFramedBlock framedBlock = CamoItemStackHelper.getFramedBlock(itemStack);
        if (framedBlock != null) {
            ItemStack plainFrame = new ItemStack((ItemLike)itemStack.getItem());
            List<ItemStack> camoBlocks = CamoItemStackHelper.dropCamo(itemStack);
            int camoCount = camoBlocks.size();
            if (camoCount == 1) {
                RecipeHolder<CraftingRecipe> recipe = this.createRecipe((Either<ItemStack, TagKey<Item>>)Either.left((Object)plainFrame), (Either<ItemStack, TagKey<Item>>)Either.left((Object)camoBlocks.getFirst()), (Either<ItemStack, TagKey<Item>>)Either.left((Object)ItemStack.EMPTY), List.of(itemStack));
                return List.of(recipe);
            }
            if (camoCount == 2 && CamoItemStackHelper.isDoubleFramedBlock(framedBlock)) {
                RecipeHolder<CraftingRecipe> recipe = this.createRecipe((Either<ItemStack, TagKey<Item>>)Either.left((Object)plainFrame), (Either<ItemStack, TagKey<Item>>)Either.left((Object)camoBlocks.get(0)), (Either<ItemStack, TagKey<Item>>)Either.left((Object)camoBlocks.get(1)), List.of(itemStack));
                return List.of(recipe);
            }
        }
        return List.of();
    }

    public List<RecipeHolder<CraftingRecipe>> getAllRecipes() {
        return this.createRecipesForEachFrame(this.camoCraftingHelper.getEmptyFramedBlocks(), (Either<ItemStack, TagKey<Item>>)Either.right(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG));
    }

    private List<RecipeHolder<CraftingRecipe>> createRecipesForEachFrame(List<ItemStack> framedBlocks, Either<ItemStack, TagKey<Item>> camoOne) {
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        for (ItemStack framedBlock : framedBlocks) {
            recipes.add(this.createRecipeForFrame(framedBlock, camoOne));
        }
        return recipes;
    }

    private RecipeHolder<CraftingRecipe> createRecipeForFrame(ItemStack framedBlock, Either<ItemStack, TagKey<Item>> camoOne) {
        Either camoTwo = Either.left((Object)ItemStack.EMPTY);
        if (CamoItemStackHelper.isDoubleFramedBlock(framedBlock)) {
            camoTwo = Either.right(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG);
        }
        return this.createRecipe((Either<ItemStack, TagKey<Item>>)Either.left((Object)framedBlock), camoOne, (Either<ItemStack, TagKey<Item>>)camoTwo, List.of());
    }

    private RecipeHolder<CraftingRecipe> createRecipe(Either<ItemStack, TagKey<Item>> frame, Either<ItemStack, TagKey<Item>> camoOne, Either<ItemStack, TagKey<Item>> camoTwo, List<ItemStack> results) {
        Ingredient frameIngredient = (Ingredient)frame.map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0}), Ingredient::of);
        Ingredient copyTool = this.camoCraftingHelper.getCopyToolIngredient();
        Ingredient camoOneIngredient = (Ingredient)camoOne.map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0}), Ingredient::of);
        Ingredient secondInputStacks = (Ingredient)camoTwo.map(xva$0 -> Ingredient.of((ItemStack[])new ItemStack[]{xva$0}), Ingredient::of);
        JeiCamoApplicationRecipe recipe = new JeiCamoApplicationRecipe(frameIngredient, copyTool, camoOneIngredient, secondInputStacks, results);
        ResourceLocation resourceLocation = CamoRecipeManagerPlugin.generateId(frame, camoOne, camoTwo);
        return new RecipeHolder(resourceLocation, (Recipe)recipe);
    }

    private static ResourceLocation generateId(Either<ItemStack, TagKey<Item>> frame, Either<ItemStack, TagKey<Item>> camoOne, Either<ItemStack, TagKey<Item>> camoTwo) {
        String frameId = CamoRecipeManagerPlugin.mapStackOrTag(frame, List.of(Pair.of(JeiConstants.ALL_FRAMES_TAG, (Object)"all"), Pair.of(JeiConstants.DOUBLE_FRAMES_TAG, (Object)"all_double")));
        String camoOneId = CamoRecipeManagerPlugin.mapStackOrTag(camoOne, List.of(Pair.of(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG, (Object)"examples")));
        String camoTwoId = CamoRecipeManagerPlugin.mapStackOrTag(camoTwo, List.of(Pair.of(JeiConstants.CAMO_BLOCK_EXAMPLES_TAG, (Object)"examples")));
        return Utils.rl("/camo_application/jei_generated/" + frameId + "/" + camoOneId + "/" + camoTwoId);
    }

    private static String mapStackOrTag(Either<ItemStack, TagKey<Item>> value, List<Pair<TagKey<Item>, String>> converters) {
        return (String)value.map(CamoRecipeManagerPlugin::stackToString, tag -> CamoRecipeManagerPlugin.tagToString((TagKey<Item>)tag, converters));
    }

    private static String stackToString(ItemStack stack) {
        return stack.isEmpty() ? "empty" : BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toLanguageKey();
    }

    private static String tagToString(TagKey<Item> tag, List<Pair<TagKey<Item>, String>> converters) {
        for (Pair<TagKey<Item>, String> conv : converters) {
            if (!((TagKey)conv.getFirst()).equals(tag)) continue;
            return (String)conv.getSecond();
        }
        return tag.location().toLanguageKey();
    }
}

