/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.doubled.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.doubled.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public class FramedDoubleCornerBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDoubleCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.BE_TYPE_DOUBLE_FRAMED_CORNER.value(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit, Vec3 lookVec, Vec3 eyePos) {
        CornerType type = (CornerType)((Object)this.getBlockState().getValue(PropertyHolder.CORNER_TYPE));
        Direction facing = (Direction)this.getBlockState().getValue((Property)FramedProperties.FACING_HOR);
        Direction side = hit.getDirection();
        Vec3 vec = Utils.fraction(hit.getLocation());
        if (type.isHorizontal()) {
            if (side == facing || !type.isTop() && side == Direction.DOWN || type.isTop() && side == Direction.UP || !type.isRight() && side == facing.getCounterClockWise() || type.isRight() && side == facing.getClockWise()) {
                return false;
            }
            if (side == facing.getOpposite()) {
                return true;
            }
            if (Utils.isY(side)) {
                boolean secondary;
                if (type.isRight()) {
                    secondary = Utils.isX(facing) ? vec.x() >= 1.0 - vec.z() : vec.z() >= vec.x();
                } else {
                    boolean bl = Utils.isX(facing) ? vec.x() >= vec.z() : (secondary = vec.z() >= 1.0 - vec.x());
                }
                if (Utils.isPositive(facing)) {
                    secondary = !secondary;
                }
                return secondary;
            }
            if (side == facing.getClockWise() || side == facing.getCounterClockWise()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                boolean secondary = type.isTop() ? vec.y() <= 1.0 - hor : vec.y() >= hor;
                return secondary;
            }
        } else if (type == CornerType.TOP) {
            if (side == facing || side == Direction.UP || side == facing.getCounterClockWise()) {
                return false;
            }
            if (side == Direction.DOWN) {
                return true;
            }
            if (side == facing.getClockWise()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.y() <= 1.0 - hor;
            }
            if (side == facing.getOpposite()) {
                double hor;
                Direction dir = facing.getCounterClockWise();
                double d = hor = Utils.isX(dir) ? vec.x() : vec.z();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.y() <= 1.0 - hor;
            }
        } else if (type == CornerType.BOTTOM) {
            if (side == facing || side == Direction.DOWN || side == facing.getCounterClockWise()) {
                return false;
            }
            if (side == Direction.UP) {
                return true;
            }
            if (side == facing.getClockWise()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.x() : vec.z();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.y() >= hor;
            }
            if (side == facing.getOpposite()) {
                double hor;
                Direction dir = facing.getCounterClockWise();
                double d = hor = Utils.isX(dir) ? vec.x() : vec.z();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.y() >= hor;
            }
        }
        return false;
    }
}

