/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.torch;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.ChainType;

public class FramedLanternBlock
extends LanternBlock
implements IFramedBlock {
    private final BlockType type;

    public FramedLanternBlock(BlockType type) {
        super(IFramedBlock.createProperties(type).mapColor(MapColor.METAL).forceSolidOn().strength(3.5f).sound(SoundType.LANTERN).lightLevel(type == BlockType.FRAMED_SOUL_LANTERN ? state -> 10 : state -> 15).pushReaction(PushReaction.DESTROY));
        this.type = type;
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.PROPAGATES_SKYLIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.GLOWING, FramedProperties.PROPAGATES_SKYLIGHT, PropertyHolder.CHAIN_TYPE});
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return this.handleUse(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)Utils.FRAMED_HAMMER.value())) {
            if (!level.isClientSide()) {
                state = (BlockState)state.setValue(PropertyHolder.CHAIN_TYPE, (Comparable)((Object)((ChainType)((Object)state.getValue(PropertyHolder.CHAIN_TYPE))).next()));
                level.setBlock(pos, state, 3);
            }
            return true;
        }
        return false;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return Math.max(state.getLightEmission(), super.getLightEmission(state, level, pos));
    }

    protected float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoShadeBrightness(state, level, pos, super.getShadeBrightness(state, level, pos));
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)FramedProperties.PROPAGATES_SKYLIGHT);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        return this.getCamoDrops(super.getDrops(state, builder), builder);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> lines, TooltipFlag flag) {
        this.appendCamoHoverText(stack, lines);
    }

    @Override
    public IBlockType getBlockType() {
        return this.type;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.defaultBlockState();
    }
}

