/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.sign;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.common.block.sign.AbstractFramedHangingSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedWallHangingSignBlock
extends AbstractFramedHangingSignBlock {
    public FramedWallHangingSignBlock() {
        super(BlockType.FRAMED_WALL_HANGING_SIGN, BlockBehaviour.Properties::noCollission);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(this, ctx).withCustom((state, modCtx) -> {
            BlockState adjState;
            Level level = modCtx.getLevel();
            BlockPos pos = modCtx.getClickedPos();
            Direction face = modCtx.getClickedFace();
            if (!modCtx.replacingClickedOnBlock() && (adjState = level.getBlockState(pos.relative(face.getOpposite()))).getBlock() instanceof FramedWallHangingSignBlock && ((Direction)adjState.getValue((Property)FramedProperties.FACING_HOR)).getAxis().test(face)) {
                return null;
            }
            for (Direction dir : modCtx.getNearestLookingDirections()) {
                if (!dir.getAxis().isHorizontal() || dir.getAxis().test(face) || !(state = (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir.getOpposite())).canSurvive((LevelReader)level, pos) || !FramedWallHangingSignBlock.canPlace(state, (LevelReader)level, pos)) continue;
                return state;
            }
            return null;
        })).withWater()).build();
    }

    @Override
    protected boolean preventUse(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, BlockHitResult hit) {
        boolean front;
        FramedSignBlockEntity sign;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FramedSignBlockEntity && (sign = (FramedSignBlockEntity)blockEntity).cannotExecuteCommands(front = sign.isFacingFrontText(player), player) && stack.getItem() == this.asItem()) {
            return hit.getDirection().getAxis() == ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).getAxis();
        }
        return false;
    }

    @Override
    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)) {
            case Direction.NORTH, Direction.SOUTH -> WallHangingSignBlock.SHAPE_NORTHSOUTH;
            case Direction.EAST, Direction.WEST -> WallHangingSignBlock.SHAPE_EASTWEST;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    protected VoxelShape getBlockSupportShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)) {
            case Direction.NORTH, Direction.SOUTH -> WallHangingSignBlock.PLANK_NORTHSOUTH;
            case Direction.EAST, Direction.WEST -> WallHangingSignBlock.PLANK_EASTWEST;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    @Override
    public float getYRotationDegrees(BlockState state) {
        return ((Direction)state.getValue((Property)FramedProperties.FACING_HOR)).toYRot();
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate((Direction)state.getValue((Property)FramedProperties.FACING_HOR)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FramedProperties.FACING_HOR)));
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    @Override
    @Nullable
    public BlockState getItemModelSource() {
        return null;
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return state;
    }

    public static boolean canPlace(BlockState state, LevelReader level, BlockPos pos) {
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        Direction dirCw = dir.getClockWise();
        Direction dirCcw = dir.getCounterClockWise();
        return FramedWallHangingSignBlock.canAttachTo(level, state, pos.relative(dirCw), dirCcw) || FramedWallHangingSignBlock.canAttachTo(level, state, pos.relative(dirCcw), dirCw);
    }

    private static boolean canAttachTo(LevelReader level, BlockState state, BlockPos pos, Direction side) {
        BlockState adjState = level.getBlockState(pos);
        if (adjState.getBlock() instanceof FramedWallHangingSignBlock) {
            return ((Direction)adjState.getValue((Property)FramedProperties.FACING_HOR)).getAxis().test((Direction)state.getValue((Property)FramedProperties.FACING_HOR));
        }
        return adjState.isFaceSturdy((BlockGetter)level, pos, side, SupportType.FULL);
    }
}

