/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.overlay;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.screen.overlay.BlockInteractOverlay;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.config.ClientConfig;

public final class StateLockOverlay
extends BlockInteractOverlay {
    public static final String LOCK_MESSAGE = Utils.translationKey("tooltip", "lock_state");
    private static final List<Component> LINES_FALSE = List.of(Component.translatable((String)LOCK_MESSAGE, (Object[])new Object[]{IFramedBlock.STATE_UNLOCKED}));
    private static final List<Component> LINES_TRUE = List.of(Component.translatable((String)LOCK_MESSAGE, (Object[])new Object[]{IFramedBlock.STATE_LOCKED}));
    private static final ResourceLocation SYMBOL_TEXTURE = Utils.rl("textures/overlay/state_lock_symbols.png");
    private static final BlockInteractOverlay.Texture TEXTURE_FALSE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 0, 0, 22, 22, 44, 22);
    private static final BlockInteractOverlay.Texture TEXTURE_TRUE = new BlockInteractOverlay.Texture(SYMBOL_TEXTURE, 22, 0, 22, 22, 44, 22);

    public StateLockOverlay() {
        super("state_lock", LINES_FALSE, LINES_TRUE, TEXTURE_FALSE, TEXTURE_TRUE, ClientConfig.VIEW::getStateLockMode);
    }

    @Override
    protected boolean isValidTool(ItemStack stack) {
        return stack.is((Item)FBContent.ITEM_FRAMED_KEY.value());
    }

    @Override
    protected boolean isValidTarget(BlockInteractOverlay.Target target) {
        IFramedBlock block;
        Block block2 = target.state().getBlock();
        return block2 instanceof IFramedBlock && (block = (IFramedBlock)block2).getBlockType().canLockState();
    }

    @Override
    protected boolean getState(BlockInteractOverlay.Target target) {
        return (Boolean)target.state().getValue((Property)FramedProperties.STATE_LOCKED);
    }
}

