/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainer;
import xfacthd.framedblocks.api.util.ConfigView;
import xfacthd.framedblocks.api.util.Utils;

public abstract class AbstractBlockCamoContainerFactory<T extends AbstractBlockCamoContainer<T>>
extends CamoContainerFactory<T> {
    @Override
    public final T applyCamo(Level level, BlockPos pos, Player player, ItemStack stack) {
        BlockState state = this.getStateFromItemStack(level, pos, player, stack);
        if (state != null && !(state.getBlock() instanceof IFramedBlock) && this.isValidBlock(state, (BlockGetter)level, pos, player)) {
            T container = this.createContainer(state, level, pos, player, stack);
            if (!level.isClientSide() && !player.isCreative() && ConfigView.Server.INSTANCE.shouldConsumeCamoItem()) {
                stack.shrink(1);
                player.getInventory().setChanged();
            }
            return container;
        }
        return null;
    }

    @Override
    public final boolean removeCamo(Level level, BlockPos pos, Player player, ItemStack stack, T container) {
        if (!level.isClientSide()) {
            ItemStack result = this.createItemStack(level, pos, player, stack, container);
            Utils.giveToPlayer(player, result, ConfigView.Server.INSTANCE.shouldConsumeCamoItem());
        }
        return true;
    }

    @Override
    public final boolean validateCamo(T container) {
        if (((AbstractBlockCamoContainer)container).getState().getBlock() instanceof IFramedBlock) {
            return false;
        }
        return this.isValidBlock(((AbstractBlockCamoContainer)container).getState(), (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null);
    }

    @Nullable
    protected BlockState getStateFromItemStack(Level level, BlockPos pos, Player player, ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem item2 = (BlockItem)item;
            return item2.getBlock().defaultBlockState();
        }
        return null;
    }

    protected abstract T createContainer(BlockState var1, Level var2, BlockPos var3, Player var4, ItemStack var5);

    protected abstract T copyContainerWithState(T var1, BlockState var2);

    protected abstract ItemStack createItemStack(Level var1, BlockPos var2, Player var3, ItemStack var4, T var5);

    protected abstract boolean isValidBlock(BlockState var1, BlockGetter var2, BlockPos var3, @Nullable Player var4);

    @ApiStatus.Internal
    public final boolean isValidBlockInternal(BlockState camoState) {
        return this.isValidBlock(camoState, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO, null);
    }
}

