/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.camo;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.util.Utils;

final class CamoResolvingLevelReader
implements LevelReader {
    private final LevelReader wrapped;
    private final BlockPos origin;

    CamoResolvingLevelReader(LevelReader wrapped, BlockPos origin) {
        this.wrapped = wrapped;
        this.origin = origin;
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockState state = this.wrapped.getBlockState(pos);
        if (state.getBlock() instanceof IFramedBlock) {
            Direction side = Utils.dirByNormal(pos, this.origin);
            if (side == null || !state.isFaceSturdy((BlockGetter)this.wrapped, pos, side, SupportType.FULL)) {
                return Blocks.AIR.defaultBlockState();
            }
            BlockEntity blockEntity = this.wrapped.getBlockEntity(pos);
            if (blockEntity instanceof FramedBlockEntity) {
                FramedBlockEntity be = (FramedBlockEntity)blockEntity;
                return ((CamoContent)be.getCamo(side).getContent()).getAsBlockState();
            }
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public FluidState getFluidState(BlockPos pos) {
        return this.wrapped.getFluidState(pos);
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos) {
        return this.wrapped.getBlockEntity(pos);
    }

    @Nullable
    public ChunkAccess getChunk(int x, int z, ChunkStatus status, boolean required) {
        return this.wrapped.getChunk(x, z, status, required);
    }

    @Deprecated
    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.wrapped.hasChunk(chunkX, chunkZ);
    }

    public int getHeight(Heightmap.Types pHeightmapType, int pX, int pZ) {
        return this.wrapped.getHeight();
    }

    public int getSkyDarken() {
        return this.wrapped.getSkyDarken();
    }

    public BiomeManager getBiomeManager() {
        return this.wrapped.getBiomeManager();
    }

    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        return this.wrapped.getUncachedNoiseBiome(x, y, z);
    }

    public boolean isClientSide() {
        return this.wrapped.isClientSide();
    }

    @Deprecated
    public int getSeaLevel() {
        return this.wrapped.getSeaLevel();
    }

    public DimensionType dimensionType() {
        return this.wrapped.dimensionType();
    }

    public RegistryAccess registryAccess() {
        return this.wrapped.registryAccess();
    }

    public FeatureFlagSet enabledFeatures() {
        return this.wrapped.enabledFeatures();
    }

    public float getShade(Direction side, boolean shade) {
        return this.wrapped.getShade(side, shade);
    }

    public float getShade(float normalX, float normalY, float normalZ, boolean shade) {
        return this.wrapped.getShade(normalX, normalY, normalZ, shade);
    }

    public LevelLightEngine getLightEngine() {
        return this.wrapped.getLightEngine();
    }

    public WorldBorder getWorldBorder() {
        return this.wrapped.getWorldBorder();
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, AABB box) {
        return this.wrapped.getEntityCollisions(entity, box);
    }
}

