/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class KelpPlantRecollectable
extends PlantRecollectable {
    public KelpPlantRecollectable() {
        super("kelp");
    }

    @Override
    public boolean canBeHarvested(Level world, BlockPos pos, BlockState blockState) {
        return world.getBlockState(pos).getBlock().equals(Blocks.KELP_PLANT) && (world.getBlockState(pos.above()).getBlock().equals(Blocks.KELP) || world.getBlockState(pos.above()).getBlock().equals(Blocks.KELP_PLANT));
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState) {
        while (world.getBlockState(pos.above()).getBlock().equals(Blocks.KELP) || world.getBlockState(pos.above()).getBlock().equals(Blocks.KELP_PLANT)) {
            pos = pos.above();
        }
        NonNullList stacks = NonNullList.create();
        stacks.addAll(BlockUtils.getBlockDrops(world, pos));
        world.setBlockAndUpdate(pos, Blocks.WATER.defaultBlockState());
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(Level world, BlockPos pos, BlockState blockState) {
        return world.getBlockState(pos).getBlock().equals(Blocks.KELP);
    }

    @Override
    public ItemStack getSeedDrop(Level world, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)Blocks.KELP);
    }
}

