/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.spawner;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.PhantomSpawner;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerSpawnPhantomsEvent;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;

public final class CustomPhantomSpawner
extends PhantomSpawner {
    public int tick(ServerLevel level, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        if (!spawnHostileMobs || !level.getGameRules().getBoolean(GameRules.RULE_DOINSOMNIA) || --this.nextTick > 0) {
            return 0;
        }
        RandomSource randomSource = level.random;
        this.nextTick += (60 + randomSource.nextInt(60)) * 20;
        if (level.getSkyDarken() < 5 && level.dimensionType().hasSkyLight()) {
            return 0;
        }
        int i = 0;
        for (ServerPlayer player : level.players()) {
            FluidState ifluidstate;
            BlockState iblockstate;
            BlockPos blockpos1;
            boolean isAllow;
            if (player.isSpectator()) continue;
            BlockPos currentPos = player.blockPosition();
            PlayerSpawnPhantomsEvent event = EventHooks.firePlayerSpawnPhantoms((ServerPlayer)player, (ServerLevel)level, (BlockPos)currentPos);
            boolean bl = isAllow = event.getResult() == PlayerSpawnPhantomsEvent.Result.ALLOW;
            if (!event.shouldSpawnPhantoms(level, currentPos)) continue;
            DifficultyInstance diffForLocation = level.getCurrentDifficultyAt(currentPos);
            if (!isAllow && !diffForLocation.isHarderThan(randomSource.nextFloat() * 3.0f)) continue;
            int timeForCheck = EventFactory.onPhantomTime((Player)player, (Integer)ConfigTombstone.general.timeForPhantomSpawn.get());
            int timeSinceRest = Mth.clamp((int)EntityHelper.getCustomStat(player, Stats.TIME_SINCE_REST), (int)1, (int)Integer.MAX_VALUE);
            if (!isAllow && !EventFactory.onCheckPhantomSpawn((Player)player, timeForCheck, timeSinceRest, randomSource.nextInt(timeSinceRest) >= timeForCheck) || !NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)(blockpos1 = currentPos.above(20 + randomSource.nextInt(15)).east(-10 + randomSource.nextInt(21)).south(-10 + randomSource.nextInt(21))), (BlockState)(iblockstate = level.getBlockState(blockpos1)), (FluidState)(ifluidstate = level.getFluidState(blockpos1)), (EntityType)EntityType.PHANTOM)) continue;
            SpawnGroupData spawngroupdata = null;
            int l = event.getPhantomsToSpawn();
            for (int i1 = 0; i1 < l; ++i1) {
                Phantom phantom = (Phantom)EntityType.PHANTOM.create((Level)level);
                if (phantom == null) continue;
                phantom.moveTo(blockpos1, 0.0f, 0.0f);
                spawngroupdata = phantom.finalizeSpawn((ServerLevelAccessor)level, diffForLocation, MobSpawnType.NATURAL, spawngroupdata);
                level.addFreshEntityWithPassengers((Entity)phantom);
                ++i;
            }
        }
        return i;
    }
}

