/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.combine.TooltipDyeable;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemSmokeBall
extends ItemGeneric {
    private TooltipComponent tooltip;

    public ItemSmokeBall() {
        super("smoke_ball", () -> SharedConfigTombstone.allowed_magic_items.allowSmokeBall.get());
        this.withDefaultInfo().withCombineInfo();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.getItemInHand(hand);
        if (heldStack.is((Item)this)) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SNOWBALL_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (Helper.RANDOM.nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                Snowball snowball = new Snowball(level, (LivingEntity)player);
                snowball.setItem(heldStack.copy());
                snowball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                level.addFreshEntity((Entity)snowball);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                heldStack.shrink(1);
            }
            return InteractionResultHolder.sidedSuccess((Object)heldStack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)heldStack);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return Optional.ofNullable(context.getPlayer()).map(player -> this.use(context.getLevel(), (Player)player, context.getHand()).getResult()).orElse(InteractionResult.FAIL);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        return 0xFF000000 | (Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)0x808080);
    }

    public void setColor(ItemStack stack, int color) {
        int oldColor = (Integer)stack.getOrDefault(ModDataComponents.COLOR, (Object)-1);
        stack.set(ModDataComponents.COLOR, (Object)(oldColor < 0 ? color : Helper.combineColor(oldColor, color)));
    }

    public boolean overrideOtherStackedOnMe(ItemStack smokeBall, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        Item item;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && smokeBall.is((Item)this) && (item = added.getItem()) instanceof DyeItem) {
            boolean isServerSide;
            DyeItem dyeItem = (DyeItem)item;
            boolean bl = isServerSide = !player.level().isClientSide();
            if (isServerSide || player.isCreative()) {
                this.setColor(smokeBall, dyeItem.getDyeColor().getFireworkColor());
                added.shrink(1);
                if (isServerSide) {
                    ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    ModTriggers.color_smoke_ball.trigger((ServerPlayer)player);
                } else {
                    PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COLOR_SMOKE_BALL));
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = new TooltipDyeable(stack, (result, dye) -> {
                this.setColor((ItemStack)result, dye.getDyeColor().getFireworkColor());
                return result;
            });
        }
        return Optional.of(this.tooltip);
    }
}

