/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollBuff
extends ItemScroll {
    private final SpellBuff spellBuff;

    public ItemScrollBuff(SpellBuff spellBuff) {
        super("scroll_of_" + spellBuff.getName(), ItemScrollBuff.getBuilder().stacksTo(64), spellBuff::isEnabled);
        this.spellBuff = spellBuff;
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        this.addEffectInfo(tooltip, this.spellBuff.potionSupplier.get());
        if (this.isEnchanted(stack)) {
            tooltip.add((Component)(this.isAncient(stack) ? LangKey.MESSAGE_AREA_BUFF : LangKey.MESSAGE_USEABLE_ON_ALLY).getText(new Object[0]).withStyle(StyleType.EFFECT_DESCRIPTION));
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE2, new Object[0]);
        } else {
            this.addItemUse(tooltip, LangKey.ITEM_SCROLL_BUFF_USE1, new Object[0]);
        }
        ProxyHelper.getClientPlayer().ifPresent(player -> tooltip.add((Component)Component.literal((String)("(" + StringUtil.formatTickDuration((int)Mth.floor((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus(player, ModPerks.glyphographer) * 0.1f))), (float)context.tickRate()) + ")")).setStyle(StyleType.MESSAGE_SPELL)));
        super.addTooltipInfo(stack, context, tooltip);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            ItemStack enchantedStack = new ItemStack((ItemLike)this);
            enchantedStack.set(ModDataComponents.ENCHANTED, (Object)true);
            toAdd.accept(enchantedStack);
            ItemStack ancientStack = enchantedStack.copy();
            ancientStack.set(ModDataComponents.ANCIENT, (Object)true);
            toAdd.accept(ancientStack);
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.is((Item)this)) {
            int consume;
            ItemStack enchantedStack = stack.copy();
            enchantedStack.setCount(1);
            enchantedStack.set(ModDataComponents.ENCHANTED, (Object)true);
            int n = consume = !this.isAncient(enchantedStack) && soulStrength > 1 ? 2 : 1;
            if (consume == 2) {
                enchantedStack.set(ModDataComponents.ANCIENT, (Object)true);
            }
            stack.shrink(1);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)enchantedStack);
            return ISoulConsumer.ConsumeResult.success(consume);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        MobEffectInstance effectInstance = new MobEffectInstance(this.spellBuff.potionSupplier.get(), Mth.floor((float)((float)((Integer)SharedConfigTombstone.magic_item.scrollDuration.get()).intValue() * (1.0f + (float)EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.glyphographer) * 0.1f))));
        MutableComponent effectName = ((MobEffect)effectInstance.getEffect().value()).getDisplayName().plainCopy().setStyle(StyleType.MESSAGE_SPECIAL);
        if (this.isAncient(stack)) {
            List<LivingEntity> allies = level.getEntities((Entity)player, player.getBoundingBox().inflate(3.0, 0.0, 3.0), e -> e != null && e.isAlive()).stream().filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).filter(e -> this.isTargetForCasting((Player)player, (LivingEntity)e)).toList();
            allies.forEach(arg_0 -> ItemScrollBuff.lambda$doEffects$3(effectInstance, (Component)effectName, arg_0));
            ModTriggers.cast_on_ally.trigger(player, allies.size());
            EffectHelper.addEffect((LivingEntity)player, new MobEffectInstance(effectInstance));
            LangKey.MESSAGE_SPELL_CAST_AROUND.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName});
        } else {
            if (target == null) {
                target = player;
            }
            EffectHelper.addEffect(target, new MobEffectInstance(effectInstance));
            if (EntityHelper.isValidServerPlayer((Entity)target)) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)target), StyleType.MESSAGE_SPELL, new Object[]{effectName});
            }
            if (!target.equals((Object)player)) {
                ModTriggers.cast_on_ally.trigger(player);
                LangKey.MESSAGE_SPELL_CAST_ON_TARGET.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{effectName, target.getName().plainCopy().setStyle(StyleType.TOOLTIP_ITEM)});
            }
        }
        ModTriggers.spell_buff.get((Object)this.spellBuff).trigger(player);
        return true;
    }

    @Override
    protected boolean canAffectTarget(ItemStack stack, LivingEntity target) {
        return !this.isAncient(stack) && target.canBeAffected(new MobEffectInstance(this.spellBuff.potionSupplier.get()));
    }

    private static /* synthetic */ void lambda$doEffects$3(MobEffectInstance effectInstance, Component effectName, LivingEntity e) {
        EffectHelper.addEffect(e, new MobEffectInstance(effectInstance));
        if (EntityHelper.isValidServerPlayer((Entity)e)) {
            LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMessage((Player)((ServerPlayer)e), StyleType.MESSAGE_SPELL, new Object[]{effectName});
        }
    }

    public static enum SpellBuff {
        PRESERVATION(() -> ModEffects.preservation, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPreservation.get()),
        UNSTABLE_INTANGIBILITY(() -> ModEffects.unstable_intangibility, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfUnstableIntangibility.get()),
        FEATHER_FALL(() -> ModEffects.feather_fall, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFeatherFall.get()),
        PURIFICATION(() -> ModEffects.purification, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfPurification.get()),
        TRUE_SIGHT(() -> ModEffects.true_sight, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfTrueSight.get()),
        REACH(() -> ModEffects.reach, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfReach.get()),
        LIGHTNING_RESISTANCE(() -> ModEffects.lightning_resistance, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfLightningResistance.get()),
        FROST_RESISTANCE(() -> ModEffects.frost_resistance, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfFrostResistance.get()),
        AQUATIC_LIFE(() -> ModEffects.aquatic_life, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfAquaticLife.get()),
        MERCY(() -> ModEffects.mercy, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfMercy.get()),
        PROJECTILE_REFLECTION(() -> ModEffects.projectile_reflection, () -> SharedConfigTombstone.allowed_magic_items.allowScrollOfProjectileReflection.get());

        private final Supplier<Holder<MobEffect>> potionSupplier;
        private final BooleanSupplier supplierEnabled;

        private SpellBuff(Supplier<Holder<MobEffect>> potionSupplier, BooleanSupplier supplierEnabled) {
            this.potionSupplier = potionSupplier;
            this.supplierEnabled = supplierEnabled;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isEnabled() {
            return this.supplierEnabled.getAsBoolean();
        }

        public Item getItem() {
            return ModItems.scroll_buff.get((Object)this);
        }

        public ItemStack getEnchantedStack() {
            ItemStack stack = new ItemStack((ItemLike)this.getItem());
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            return stack;
        }

        public ItemStack getAncientStack() {
            ItemStack stack = this.getEnchantedStack();
            stack.set(ModDataComponents.ANCIENT, (Object)true);
            return stack;
        }

        public static Optional<ItemStack> getRandomEnchantedScroll(boolean isAncient) {
            return Helper.getRandomInList(Arrays.stream(SpellBuff.values()).filter(SpellBuff::isEnabled).collect(Collectors.toList())).map(buff -> {
                ItemStack stack = new ItemStack((ItemLike)buff.getItem());
                stack.set(ModDataComponents.ENCHANTED, (Object)true);
                if (isAncient) {
                    stack.set(ModDataComponents.ANCIENT, (Object)true);
                }
                return stack;
            });
        }
    }
}

