/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fStack;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.RenderHelper;

@OnlyIn(value=Dist.CLIENT)
public final class CustomToast
implements Toast {
    public static final CustomToast INSTANCE = new CustomToast();
    private static final long DISPLAY_TIME = 5000L;
    private final Component title = LangKey.MESSAGE_COMBINE_IN_INVENTORY.getText(new Object[0]);
    @Nullable
    private Pair<ItemStack, ItemStack> combination;
    private Component description;
    private long lastChanged;
    private boolean changed;

    private CustomToast() {
    }

    public Object getToken() {
        return this;
    }

    public int width() {
        return 200;
    }

    public int height() {
        return 50;
    }

    public void addCombination(ItemStack initial, ItemStack added, Component description) {
        ToastComponent toastHandler = Minecraft.getInstance().getToasts();
        CustomToast customToast = (CustomToast)toastHandler.getToast(this.getClass(), this.getToken());
        if (customToast == null) {
            toastHandler.queued.add(this);
        }
        this.combination = Pair.of((Object)initial, (Object)added);
        this.description = description;
        this.changed = true;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent compo, long time) {
        if (this.changed) {
            this.lastChanged = time;
            this.changed = false;
        }
        if (this.combination == null || !(compo.getMinecraft().screen instanceof EffectRenderingInventoryScreen)) {
            return Toast.Visibility.HIDE;
        }
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(compo.getMinecraft().font);
        int lineHeight = 9;
        List splits = compo.getMinecraft().font.split((FormattedText)this.description, this.width());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int y = (compo.getMinecraft().getWindow().getGuiScaledHeight() - this.height()) / 2;
        guiGraphics.fill(0, y, this.width(), y + 22 + lineHeight * splits.size(), -341384);
        guiGraphics.fill(1, y + 1, this.width(), y + 21 + lineHeight * splits.size(), -14274713);
        guiGraphics.fill(4, y + 2, 20, y + 18, -4144960);
        guiGraphics.fill(48, y + 2, 64, y + 18, -4144960);
        guiGraphics.drawString(font, this.title.getString(), 70.0f, (float)(y + 6), -341384, false);
        float height = y + 20;
        for (FormattedCharSequence split : splits) {
            guiGraphics.drawString(font, split, 4.0f, height, -11141121, false);
            height += (float)lineHeight;
        }
        ItemStack left = (ItemStack)this.combination.getLeft();
        ItemStack right = (ItemStack)this.combination.getRight();
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        matrixStack.translate(0.0f, (float)y, 0.0f);
        RenderSystem.applyModelViewMatrix();
        guiGraphics.renderItem(left, 4, 2);
        RenderHelper.Sprites.MOUSE_ON.render(guiGraphics, 32, 2, 0.8f);
        RenderHelper.Sprites.ARROW_SPRITE.render(guiGraphics, 20, 6, 0.7f);
        matrixStack.translate(44.0f, 0.0f, 0.0f);
        RenderSystem.applyModelViewMatrix();
        guiGraphics.renderItem(right, 4, 2);
        matrixStack.popMatrix();
        return time - this.lastChanged >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

