/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.ai.spell.AbstractOffensiveSpellGoal;

public class CurseSpellGoal
extends AbstractOffensiveSpellGoal {
    private final MobEffectInstance mobEffectInstance;
    private int lastTargetId;

    public CurseSpellGoal(PathfinderMob caster, MobEffectInstance mobEffectInstance) {
        super(caster);
        this.mobEffectInstance = mobEffectInstance;
    }

    @Override
    public boolean canUse() {
        if (!super.canUse()) {
            return false;
        }
        LivingEntity target = this.caster.getTarget();
        assert (target != null);
        return target.getId() != this.lastTargetId && target.canBeAffected(this.mobEffectInstance);
    }

    @Override
    public void start() {
        super.start();
        Optional.ofNullable(this.caster.getTarget()).ifPresent(target -> {
            this.lastTargetId = target.getId();
        });
    }

    @Override
    protected void performSpellCasting() {
        Optional.ofNullable(this.caster.getTarget()).ifPresent(target -> target.addEffect(new MobEffectInstance(this.mobEffectInstance), (Entity)this.caster));
    }

    @Override
    protected int getCastWarmupTime() {
        return 20;
    }

    @Override
    protected int getCastingTime() {
        return 30;
    }

    @Override
    protected int getCastingInterval() {
        return 100;
    }

    @Override
    @Nullable
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.ILLUSIONER_PREPARE_BLINDNESS;
    }

    @Override
    protected int getSpellColor() {
        return ((MobEffect)this.mobEffectInstance.getEffect().value()).getColor() & 0xFFFFFF;
    }
}

