/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;

public record ApplyStackableEffect(HolderSet<MobEffect> toApply, LevelBasedValue minDuration, LevelBasedValue maxDuration, LevelBasedValue minAmplifier, LevelBasedValue maxAmplifier) implements EnchantmentEntityEffect
{
    public static final MapCodec<ApplyStackableEffect> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).fieldOf("to_apply").forGetter(ApplyStackableEffect::toApply), (App)LevelBasedValue.CODEC.fieldOf("min_duration").forGetter(ApplyStackableEffect::minDuration), (App)LevelBasedValue.CODEC.fieldOf("max_duration").forGetter(ApplyStackableEffect::maxDuration), (App)LevelBasedValue.CODEC.fieldOf("min_amplifier").forGetter(ApplyStackableEffect::minAmplifier), (App)LevelBasedValue.CODEC.fieldOf("max_amplifier").forGetter(ApplyStackableEffect::maxAmplifier)).apply((Applicative)c, ApplyStackableEffect::new));

    public void apply(ServerLevel level, int enchantmentLevel, EnchantedItemInUse itemInUse, Entity entity, Vec3 origin) {
        Holder effectHolder;
        LivingEntity target;
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity).isAlive() && (effectHolder = (Holder)this.toApply.getRandomElement(Helper.RANDOM_SOURCE).orElse(null)) != null) {
            int duration = Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minDuration.calculate(enchantmentLevel), (float)this.maxDuration.calculate(enchantmentLevel)) * 20.0f);
            int amplifier = Math.max(0, Math.round(Mth.randomBetween((RandomSource)Helper.RANDOM_SOURCE, (float)this.minAmplifier.calculate(enchantmentLevel), (float)this.maxAmplifier.calculate(enchantmentLevel))));
            int oldDuration = EffectHelper.getDuration(target, (Holder<MobEffect>)effectHolder, amplifier);
            if (oldDuration >= 0) {
                target.addEffect(new MobEffectInstance(effectHolder, Mth.clamp((int)(duration + oldDuration), (int)-1, (int)Integer.MAX_VALUE), amplifier));
            }
        }
    }

    public MapCodec<ApplyStackableEffect> codec() {
        return CODEC;
    }
}

