/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.effect;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ovh.corail.tombstone.effect.TombstoneEffect;
import ovh.corail.tombstone.helper.EffectHelper;

public class LittleWorldEffect
extends TombstoneEffect {
    public LittleWorldEffect() {
        super(MobEffectCategory.BENEFICIAL, -7805717);
        this.addAttributeModifier(Attributes.MOVEMENT_SPEED, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"little_world_movement_speed"), 0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        this.addAttributeModifier(Attributes.MOVEMENT_EFFICIENCY, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"little_world_movement_efficiency"), 0.1f, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.SCALE, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"little_world_scale"), -0.1f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        this.addAttributeModifier(Attributes.STEP_HEIGHT, ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"little_world_step_height"), -0.05f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide()) {
            EffectHelper.clearEffect(entity, effect -> effect == MobEffects.MOVEMENT_SPEED);
        }
        return true;
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 10 == 0;
    }
}

