/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.allthemods.alltheores.datagen.ATODataProvider;
import net.allthemods.alltheores.datagen.assets.ATOBlockStateProvider;
import net.allthemods.alltheores.datagen.assets.ATOItemModelProvider;
import net.allthemods.alltheores.datagen.assets.lang.EN_USProvider;
import net.allthemods.alltheores.datagen.data.ATODatapackGenerators;
import net.allthemods.alltheores.datagen.data.ATOLootTableProvider;
import net.allthemods.alltheores.datagen.data.recipe.ATORecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.actuallyadditions.ATOAACrushingRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.enderio.ATOEIOAlloySmelterRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.enderio.ATOEIOSagMillRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.immersiveengineering.ATOIEAlloyRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.immersiveengineering.ATOIEArcFurnaceRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.immersiveengineering.ATOIECrusherRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.immersiveengineering.ATOIEMetalPressRecipeProvider;
import net.allthemods.alltheores.datagen.data.recipe.mekanism.ATOMekanismRecipeProvider;
import net.allthemods.alltheores.datagen.data.tags.ATOBlockTagProvider;
import net.allthemods.alltheores.datagen.data.tags.ATOFluidTagProvider;
import net.allthemods.alltheores.datagen.data.tags.ATOItemTagProvider;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="alltheores", bus=EventBusSubscriber.Bus.MOD)
public final class ATODataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        if (!event.getModContainer().getModId().equals("alltheores")) {
            return;
        }
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture<HolderLookup.Provider> lookupProvider = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        ATODataProvider provider = new ATODataProvider();
        provider.addSubProvider(event.includeClient(), (DataProvider)new ATOBlockStateProvider(generator, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new ATOItemModelProvider(generator, fileHelper));
        provider.addSubProvider(event.includeClient(), (DataProvider)new EN_USProvider(packOutput));
        ATOBlockTagProvider blockTags = new ATOBlockTagProvider(packOutput, lookupProvider, fileHelper);
        provider.addSubProvider(event.includeServer(), (DataProvider)blockTags);
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOItemTagProvider(packOutput, lookupProvider, blockTags.contentsGetter(), fileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOFluidTagProvider(packOutput, lookupProvider, fileHelper));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATORecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOMekanismRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOEIOSagMillRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOEIOAlloySmelterRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOIEAlloyRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOIEArcFurnaceRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOIECrusherRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOIEMetalPressRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATOAACrushingRecipeProvider(packOutput, lookupProvider));
        provider.addSubProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(ATOLootTableProvider::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        provider.addSubProvider(event.includeServer(), (DataProvider)new ATODatapackGenerators(packOutput, lookupProvider));
        generator.addProvider(true, (DataProvider)provider);
    }
}

