/*
 * Decompiled with CFR 0.152.
 */
package net.allthemods.alltheores.content.blocks.sets.ato_sets;

import java.util.ArrayList;
import java.util.List;
import net.allthemods.alltheores.content.blocks.ore.OreBlockEnd;
import net.allthemods.alltheores.content.blocks.ore.OreBlockNether;
import net.allthemods.alltheores.content.blocks.ore.OreBlockOther;
import net.allthemods.alltheores.content.blocks.ore.OreBlockSlate;
import net.allthemods.alltheores.content.blocks.ore.OreBlockStone;
import net.allthemods.alltheores.content.blocks.sets.BlockSet;
import net.allthemods.alltheores.content.blocks.sets.ESetTypes;
import net.allthemods.alltheores.infos.Reference;
import net.allthemods.alltheores.registry.ATORegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ATOOreSet
extends BlockSet {
    public final ESetTypes type;
    public final String hardness;
    private static final List<ATOOreSet> instances = new ArrayList<ATOOreSet>();
    public final int veinSize;
    public final int minY;
    public final int maxY;
    public final int count;
    public final ResourceKey<ConfiguredFeature<?, ?>> CONFIGURED_ORE_FEATURE;
    public final ResourceKey<PlacedFeature> PLACED_ORE_FEATURE;
    public final ResourceKey<BiomeModifier> OVERWORLD_BIOME_MODIFIER;
    public final ResourceKey<BiomeModifier> NETHER_BIOME_MODIFIER;
    public final ResourceKey<BiomeModifier> END_MODIFIER;
    public final TagKey<Item> DROP_ITEM_TAG;
    public final TagKey<Block> ORE_BLOCK_TAG;
    public final TagKey<Block> DROP_BLOCK_TAG;
    public final TagKey<Item> ORE_BLOCK_ITEM_TAG;
    public final TagKey<Item> DROP_BLOCK_ITEM_TAG;
    public final DeferredHolder<Item, Item> DROP;
    public final DeferredHolder<Block, Block> STONE_ORE_BLOCK;
    public final DeferredHolder<Block, Block> SLATE_ORE_BLOCK;
    public final DeferredHolder<Block, Block> NETHER_ORE_BLOCK;
    public final DeferredHolder<Block, Block> END_ORE_BLOCK;
    public final DeferredHolder<Block, Block> OTHER_ORE_BLOCK;
    public final DeferredHolder<Block, Block> DROP_BLOCK;
    public final DeferredHolder<Item, BlockItem> STONE_ORE_BLOCK_ITEM;
    public final DeferredHolder<Item, BlockItem> SLATE_ORE_BLOCK_ITEM;
    public final DeferredHolder<Item, BlockItem> NETHER_ORE_BLOCK_ITEM;
    public final DeferredHolder<Item, BlockItem> END_ORE_BLOCK_ITEM;
    public final DeferredHolder<Item, BlockItem> OTHER_ORE_BLOCK_ITEM;
    public final DeferredHolder<Item, BlockItem> DROP_BLOCK_ITEM;

    public static List<ATOOreSet> getOreSets() {
        return instances;
    }

    public ATOOreSet(String name, ESetTypes type, String hardness, DeferredHolder<Item, Item> drop, DeferredHolder<Block, Block> drop_block, int veinSize, int minY, int maxY, int count) {
        super(name);
        instances.add(this);
        this.type = type;
        this.hardness = hardness;
        this.veinSize = veinSize;
        this.minY = minY;
        this.maxY = maxY;
        this.count = count;
        this.CONFIGURED_ORE_FEATURE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)String.format("ore_%s", name)));
        this.PLACED_ORE_FEATURE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)String.format("ore_%s_placed", name)));
        this.OVERWORLD_BIOME_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)String.format("%s_overworld", name)));
        this.NETHER_BIOME_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)String.format("%s_nether", name)));
        this.END_MODIFIER = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"alltheores", (String)String.format("%s_end", name)));
        switch (type) {
            case INGOT: {
                this.DROP_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.raw_materials(name));
                this.DROP_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(String.format("raw_%s", name)));
                break;
            }
            case GEM: {
                this.DROP_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.gem(name));
                this.DROP_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(name));
                break;
            }
            case DUST: {
                this.DROP_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.dust(name));
                this.DROP_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.block(name));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Type: " + name);
            }
        }
        this.ORE_BLOCK_TAG = BlockTags.create((ResourceLocation)Reference.ore(name));
        this.ORE_BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)Reference.ore(name));
        this.DROP_BLOCK_ITEM_TAG = ItemTags.create((ResourceLocation)this.DROP_BLOCK_TAG.location());
        this.DROP = drop;
        this.STONE_ORE_BLOCK = ATORegistry.BLOCKS.register(String.format("%s_ore", name), OreBlockStone::new);
        this.SLATE_ORE_BLOCK = ATORegistry.BLOCKS.register(String.format("deepslate_%s_ore", name), OreBlockSlate::new);
        this.NETHER_ORE_BLOCK = ATORegistry.BLOCKS.register(String.format("nether_%s_ore", name), OreBlockNether::new);
        this.END_ORE_BLOCK = ATORegistry.BLOCKS.register(String.format("end_%s_ore", name), OreBlockEnd::new);
        this.OTHER_ORE_BLOCK = ATORegistry.BLOCKS.register(String.format("other_%s_ore", name), OreBlockOther::new);
        this.DROP_BLOCK = drop_block;
        this.STONE_ORE_BLOCK_ITEM = ATORegistry.blockItem(this.STONE_ORE_BLOCK);
        this.SLATE_ORE_BLOCK_ITEM = ATORegistry.blockItem(this.SLATE_ORE_BLOCK);
        this.NETHER_ORE_BLOCK_ITEM = ATORegistry.blockItem(this.NETHER_ORE_BLOCK);
        this.END_ORE_BLOCK_ITEM = ATORegistry.blockItem(this.END_ORE_BLOCK);
        this.OTHER_ORE_BLOCK_ITEM = ATORegistry.blockItem(this.OTHER_ORE_BLOCK);
        this.DROP_BLOCK_ITEM = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)drop_block.getId());
    }
}

