/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import owmii.powah.Powah;
import owmii.powah.api.FluidCoolantConfig;

public record FluidCoolant(ResourceLocation id, Fluid fluid, Set<BucketItem> buckets, int coldness) {
    public static List<FluidCoolant> getAll() {
        ArrayList<FluidCoolant> result = new ArrayList<FluidCoolant>();
        Map dataMap = BuiltInRegistries.FLUID.getDataMap(FluidCoolantConfig.DATA_MAP_TYPE);
        for (Map.Entry entry : dataMap.entrySet()) {
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            FluidCoolantConfig heat = (FluidCoolantConfig)entry.getValue();
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(id);
            if (!fluid.isSource(fluid.defaultFluidState())) continue;
            HashSet<BucketItem> buckets = new HashSet<BucketItem>();
            Item bucket = fluid.getBucket();
            if (bucket instanceof BucketItem) {
                BucketItem bucketItem = (BucketItem)bucket;
                if (bucketItem.content == fluid) {
                    buckets.add(bucketItem);
                }
            }
            result.add(new FluidCoolant(Powah.id("fluid_coolant/" + id.getNamespace() + "/" + id.getPath()), fluid, buckets, heat.temperature()));
        }
        result.sort(Comparator.comparingInt(p -> p.coldness));
        return result;
    }
}

