/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.xmod.fluxnetwork;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.config.AFConfig;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;
import sonar.fluxnetworks.api.FluxCapabilities;
import sonar.fluxnetworks.api.energy.FNEnergyStorage;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public record FluxNetworkCap(IStorageService storage, IActionSource source) implements IFNEnergyStorage
{
    public static final BlockCapability<IFNEnergyStorage, Direction> CAP = FluxCapabilities.BLOCK;

    public static IFNEnergyStorage of(@Nullable IStorageService storage, IActionSource source) {
        if (storage != null) {
            return new FluxNetworkCap(storage, source);
        }
        return new FNEnergyStorage(0L);
    }

    public static long send(IFNEnergyStorage accepter, IStorageService storage, IActionSource source) {
        long drained;
        long toAdd = accepter.receiveEnergyL(AFConfig.getFluxAccessorIO(), true);
        if (toAdd > 0L && (drained = storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), toAdd, Actionable.MODULATE, source)) > 0L) {
            long actuallyDrained = accepter.receiveEnergyL(drained, false);
            long differ = drained - actuallyDrained;
            if (differ > 0L) {
                storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), differ, Actionable.MODULATE, source);
            }
            return actuallyDrained;
        }
        return 0L;
    }

    public long receiveEnergyL(long maxReceive, boolean simulate) {
        return this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), maxReceive, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long extractEnergyL(long maxExtract, boolean simulate) {
        return this.storage.getInventory().extract((AEKey)FluxKey.of(EnergyType.FE), maxExtract, Actionable.ofSimulate((boolean)simulate), this.source);
    }

    public long getEnergyStoredL() {
        return this.storage.getCachedInventory().get((AEKey)FluxKey.of(EnergyType.FE));
    }

    public long getMaxEnergyStoredL() {
        long space = this.storage.getInventory().insert((AEKey)FluxKey.of(EnergyType.FE), 0x7FFFFFFFFFFFFFFEL, Actionable.SIMULATE, this.source);
        return space + this.getEnergyStoredL();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

