/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.strategy;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import com.glodblock.github.appflux.util.AFUtil;
import com.glodblock.github.appflux.xmod.mek.MekEnergy;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public class FEExternalStorageStrategy
implements ExternalStorageStrategy {
    private final BlockCapabilityCache<IEnergyStorage, Direction> apiCache;
    private final Direction fromSide;
    private final MekEnergy inductionHandler;

    public FEExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
        this.fromSide = fromSide;
        this.inductionHandler = ModList.get().isLoaded("mekanism") ? MekEnergy.INDUCTION.create(level, fromPos) : MekEnergy.NULL.create(level, fromPos);
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable callback) {
        IEnergyStorage storage = (IEnergyStorage)this.apiCache.getCapability();
        if (storage == null && !this.inductionHandler.valid()) {
            return null;
        }
        return new FEStorageWrapper(storage, this.inductionHandler, this.fromSide, callback);
    }

    private record FEStorageWrapper(@Nullable IEnergyStorage storage, MekEnergy inductionStorage, Direction side, Runnable callback) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (FluxKey.of(EnergyType.FE).equals(what)) {
                if (this.inductionStorage.valid()) {
                    long in = this.inductionStorage.input(amount, mode, this.side);
                    if (in > 0L && mode == Actionable.MODULATE) {
                        this.callback.run();
                    }
                    return in;
                }
                if (this.storage != null) {
                    int in = this.storage.receiveEnergy(AFUtil.clampLong(amount), mode.isSimulate());
                    if (in > 0 && mode == Actionable.MODULATE) {
                        this.callback.run();
                    }
                    return in;
                }
            }
            return 0L;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (FluxKey.of(EnergyType.FE).equals(what)) {
                if (this.inductionStorage.valid()) {
                    long out = this.inductionStorage.output(amount, mode, this.side);
                    if (out > 0L && mode == Actionable.MODULATE) {
                        this.callback.run();
                    }
                    return out;
                }
                if (this.storage != null) {
                    int out = this.storage.extractEnergy(AFUtil.clampLong(amount), mode.isSimulate());
                    if (out > 0 && mode == Actionable.MODULATE) {
                        this.callback.run();
                    }
                    return out;
                }
            }
            return 0L;
        }

        public void getAvailableStacks(KeyCounter out) {
            int stored;
            if (this.inductionStorage.valid()) {
                long stored2 = this.inductionStorage.getStored();
                if (stored2 > 0L) {
                    out.add((AEKey)FluxKey.of(EnergyType.FE), stored2);
                }
            } else if (this.storage != null && (stored = this.storage.getEnergyStored()) > 0) {
                out.add((AEKey)FluxKey.of(EnergyType.FE), (long)stored);
            }
        }

        public Component getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{FluxKeyType.TYPE.getDescription()});
        }
    }
}

