/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux;

import appeng.api.AECapabilities;
import appeng.api.behaviors.GenericInternalInventory;
import com.glodblock.github.appflux.client.AFClientRegistryHandler;
import com.glodblock.github.appflux.common.AFRegistryHandler;
import com.glodblock.github.appflux.common.AFSingletons;
import com.glodblock.github.appflux.common.me.inventory.FEGenericStackInvStorage;
import com.glodblock.github.appflux.config.AFConfig;
import com.glodblock.github.appflux.network.AFNetworkHandler;
import com.glodblock.github.appflux.util.AFUtil;
import com.mojang.logging.LogUtils;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.Capabilities;
import org.slf4j.Logger;

@Mod(value="appflux")
public class AppFlux {
    public static final String MODID = "appflux";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static AppFlux INSTANCE;

    public AppFlux(IEventBus bus) {
        assert (INSTANCE == null);
        INSTANCE = this;
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AFConfig.SPEC);
        bus.addListener(e -> {
            if (e.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB)) {
                AFRegistryHandler.INSTANCE.registerTab((Registry<CreativeModeTab>)e.getRegistry(Registries.CREATIVE_MODE_TAB));
                return;
            }
            if (e.getRegistryKey().equals(Registries.BLOCK)) {
                AFSingletons.init(AFRegistryHandler.INSTANCE);
                AFRegistryHandler.INSTANCE.runRegister();
            }
        });
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(arg_0 -> ((AFNetworkHandler)AFNetworkHandler.INSTANCE).onRegister(arg_0));
        bus.register((Object)AFRegistryHandler.INSTANCE);
        if (FMLEnvironment.dist.isClient()) {
            bus.register((Object)AFClientRegistryHandler.INSTANCE);
        }
        bus.addListener(EventPriority.LOWEST, event -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                if (!event.isBlockRegistered(AECapabilities.GENERIC_INTERNAL_INV, block)) continue;
                event.registerBlock(Capabilities.EnergyStorage.BLOCK, (level, pos, state, tile, side) -> {
                    GenericInternalInventory genericInv = (GenericInternalInventory)level.getCapability(AECapabilities.GENERIC_INTERNAL_INV, pos, state, tile, side);
                    if (genericInv != null && AFUtil.shouldTryCast(tile, side)) {
                        return new FEGenericStackInvStorage(genericInv);
                    }
                    return null;
                }, new Block[]{block});
            }
        });
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        AFRegistryHandler.INSTANCE.init();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        AFClientRegistryHandler.INSTANCE.init();
    }

    public static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)id);
    }
}

