/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.mangorage.tiab.common.TiabMod;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.api.impl.ITimeAcceleratorEntity;

public class TimeAcceleratorEntity
extends Entity
implements ITimeAcceleratorEntity {
    private static final EntityDataAccessor<Integer> timeRate = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> timeRemaining = SynchedEntityData.defineId(TimeAcceleratorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos pos;

    public TimeAcceleratorEntity(Level worldIn) {
        super(((ICommonTimeInABottleAPI)TiabMod.COMMON_API.get()).getRegistration().getAcceleratorEntityType(), worldIn);
        this.entityData.set(timeRate, (Object)1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(timeRate, (Object)1);
        builder.define(timeRemaining, (Object)0);
    }

    public void tick() {
        if (this.level().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level();
        if (this.pos == null) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        BlockState blockState = level.getBlockState(this.pos);
        if (blockState.is(ICommonTimeInABottleAPI.COMMON_API.get().getTagKey())) {
            this.remove(Entity.RemovalReason.KILLED);
            this.setRemainingTime(0);
            this.setTimeRate(1);
            return;
        }
        BlockEntity targetBlockEntity = level.getBlockEntity(this.pos);
        BlockEntityTicker targetTicker = null;
        if (targetBlockEntity != null) {
            targetTicker = targetBlockEntity.getBlockState().getTicker((Level)level, targetBlockEntity.getType());
        }
        for (int i = 0; i < this.getTimeRate(); ++i) {
            if (targetTicker != null) {
                targetTicker.tick((Level)level, this.pos, blockState, targetBlockEntity);
                continue;
            }
            if (blockState.isRandomlyTicking()) {
                if (level.random.nextInt(1365) != 0) continue;
                blockState.randomTick(level, this.pos, level.getRandom());
                continue;
            }
            this.remove(Entity.RemovalReason.KILLED);
            break;
        }
        this.setRemainingTime(this.getRemainingTime() - 1);
        if (this.getRemainingTime() <= 0) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean isColliding(BlockPos $$0, BlockState $$1) {
        return false;
    }

    protected Vec3 limitPistonMovement(Vec3 $$0) {
        return Vec3.ZERO;
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(timeRate, (Object)compound.getInt("timeRate"));
        this.setRemainingTime(compound.getInt("remainingTime"));
        this.pos = NbtUtils.readBlockPos((CompoundTag)compound, (String)"position").orElse(new BlockPos(0, 0, 0));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("timeRate", this.getTimeRate());
        compound.putInt("remainingTime", this.getRemainingTime());
        compound.put("position", NbtUtils.writeBlockPos((BlockPos)this.pos));
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    @Override
    public void setBlockPos(BlockPos blockPos) {
        this.pos = blockPos.immutable();
        this.setPos((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.5, (double)this.pos.getZ() + 0.5);
    }

    @Override
    public Entity asEntity() {
        return this;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public int getTimeRate() {
        return (Integer)this.entityData.get(timeRate);
    }

    @Override
    public void setTimeRate(int rate) {
        this.entityData.set(timeRate, (Object)rate);
    }

    @Override
    public int getRemainingTime() {
        return (Integer)this.entityData.get(timeRemaining);
    }

    @Override
    public void setRemainingTime(int remainingTime) {
        this.entityData.set(timeRemaining, (Object)remainingTime);
    }
}

