/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.support;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.utils.TagFiltering;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractTieredCableLikeBlockEntity<T extends AbstractNetworkNode>
extends AbstractCableLikeBlockEntity<T>
implements BlockEntityWithDrops,
TagFiltering {
    protected static final String TAG_FILTER_MODE = "fim";
    protected static final String TAG_UPGRADES = "upgr";
    protected final CableTiers tier;
    protected final CableType type;
    protected TagFilterWithFuzzyMode filter;
    protected UpgradeContainer upgradeContainer;
    @Nullable
    private Runnable onChanged;
    private boolean inContainerMenu;

    protected AbstractTieredCableLikeBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state, T networkNode, CableTiers tier, CableType type) {
        super(blockEntityType, pos, state, networkNode);
        this.tier = tier;
        this.type = type;
    }

    public void doWork() {
        for (int i = 0; i < this.tier.getSpeed(this.type); ++i) {
            super.doWork();
        }
        if (!this.inContainerMenu) {
            return;
        }
        this.filter.doWork();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.put(TAG_UPGRADES, (Tag)ContainerUtil.write((Container)this.upgradeContainer, (HolderLookup.Provider)provider));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains(TAG_UPGRADES)) {
            ContainerUtil.read((CompoundTag)tag.getCompound(TAG_UPGRADES), (Container)this.upgradeContainer, (HolderLookup.Provider)provider);
        }
        super.loadAdditional(tag, provider);
    }

    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    public List<ItemStack> getUpgrades() {
        return this.upgradeContainer.getUpgrades();
    }

    public boolean addUpgrade(ItemStack upgradeStack) {
        return this.upgradeContainer.addUpgrade(upgradeStack);
    }

    public final NonNullList<ItemStack> getDrops() {
        return this.upgradeContainer.getDrops();
    }

    @Override
    public void setTagFilter(int index, @Nullable ResourceTag resourceTag) {
        this.filter.setFilterTag(index, resourceTag);
    }

    @Override
    @Nullable
    public TagKey<?> getTagFilter(int index) {
        return this.filter.getFilterContainer().getFilterTag(index);
    }

    @Override
    public void resetFakeFilters() {
        this.filter.resetFakeFilters();
    }

    public void setChanged() {
        super.setChanged();
        if (this.onChanged != null) {
            this.onChanged.run();
        }
    }

    @Override
    public void sendFilterTagsToClient(ServerPlayer player) {
        this.filter.sendFilterTagsToClient(player);
    }

    @Override
    public void setOnChanged(@Nullable Runnable onChanged) {
        this.onChanged = onChanged;
    }

    @Override
    public void setInContainerMenu(boolean inContainerMenu) {
        this.inContainerMenu = inContainerMenu;
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(BlockState oldBlockState, BlockState newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange((BlockState)oldBlockState, (BlockState)newBlockState);
    }
}

