/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.storage;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractStorageContainerNetworkNode;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferListener;
import com.refinedmods.refinedstorage.api.network.impl.node.storagetransfer.StorageTransferMode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNodeActor;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.api.storage.TransferHelper;
import com.refinedmods.refinedstorage.api.storage.limited.LimitedStorage;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedFilter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;

public class AdvancedStorageTransferNetworkNode
extends AbstractStorageContainerNetworkNode {
    private final AdvancedFilter filter = new AdvancedFilter();
    private final Actor actor = new NetworkNodeActor((NetworkNode)this);
    private StorageTransferMode mode = StorageTransferMode.INSERT_INTO_NETWORK;
    @Nullable
    private ToLongFunction<Storage> transferQuotaProvider;
    @Nullable
    private StorageTransferListener listener;

    public AdvancedStorageTransferNetworkNode(long energyUsage, long energyUsagePerStorage, int size) {
        super(energyUsage, energyUsagePerStorage, size);
    }

    public void setMode(StorageTransferMode mode) {
        this.mode = mode;
    }

    public StorageTransferMode getMode() {
        return this.mode;
    }

    public void setTransferQuotaProvider(ToLongFunction<Storage> transferQuotaProvider) {
        this.transferQuotaProvider = transferQuotaProvider;
    }

    public void setListener(@Nullable StorageTransferListener listener) {
        this.listener = listener;
    }

    public FilterMode getFilterMode() {
        return this.filter.getMode();
    }

    public void setFilterMode(FilterMode filterMode) {
        this.filter.setMode(filterMode);
    }

    public void setFilters(Set<ResourceKey> filters, Set<TagKey<?>> tagFilters) {
        this.filter.setFilters(filters);
        this.filter.setTagFilters(tagFilters);
    }

    public void setNormalizer(UnaryOperator<ResourceKey> normalizer) {
        this.filter.setNormalizer(normalizer);
    }

    public void doWork() {
        super.doWork();
        if (!this.isActive() || this.network == null) {
            return;
        }
        int firstNonNullIndex = -1;
        for (int i = 0; i < this.storages.length / 2; ++i) {
            if (this.storages[i] == null) continue;
            firstNonNullIndex = i;
            break;
        }
        if (firstNonNullIndex < 0) {
            return;
        }
        StorageNetworkComponent networkStorage = (StorageNetworkComponent)this.network.getComponent(StorageNetworkComponent.class);
        for (int i = firstNonNullIndex; i < this.storages.length / 2; ++i) {
            Result result;
            StateTrackedStorage storage = this.storages[i];
            if (storage == null || !this.processResult(result = this.transfer(storage, networkStorage), i)) continue;
            return;
        }
    }

    private Result transfer(StateTrackedStorage storage, StorageNetworkComponent networkStorage) {
        if (this.transferQuotaProvider == null) {
            return Result.FAILURE;
        }
        long transferQuota = this.transferQuotaProvider.applyAsLong(storage.getDelegate());
        if (this.mode == StorageTransferMode.INSERT_INTO_NETWORK) {
            return this.transfer((Storage)storage, (Storage)networkStorage, transferQuota, this::hasNoExtractableResources);
        }
        return this.transfer((Storage)networkStorage, (Storage)storage, transferQuota, source -> this.hasNoExtractableResources((Storage)source) || this.storageIsFull((Storage)storage));
    }

    private Result transfer(Storage source, Storage destination, long transferQuota, Predicate<Storage> readyPredicate) {
        if (readyPredicate.test(source)) {
            return Result.SUCCESS;
        }
        if (this.transfer(source, destination, transferQuota)) {
            return readyPredicate.test(source) ? Result.SUCCESS : Result.PARTIAL;
        }
        return Result.FAILURE;
    }

    private boolean transfer(Storage source, Storage destination, long transferQuota) {
        long remainder = transferQuota;
        LinkedHashSet sourceContents = new LinkedHashSet(source.getAll());
        for (ResourceAmount resourceAmount : sourceContents) {
            long amount;
            long transferred;
            ResourceKey resource = resourceAmount.resource();
            if (!this.filter.isAllowed(resource) || (remainder -= (transferred = TransferHelper.transfer((ResourceKey)resource, (long)(amount = Math.min(remainder, resourceAmount.amount())), (Actor)this.actor, (ExtractableStorage)source, (InsertableStorage)destination, (InsertableStorage)source))) != 0L) continue;
            return true;
        }
        return remainder != transferQuota;
    }

    private boolean hasNoExtractableResources(Storage source) {
        return source.getAll().stream().noneMatch(resourceAmount -> this.filter.isAllowed(resourceAmount.resource()));
    }

    private boolean storageIsFull(Storage storage) {
        LimitedStorage limitedStorage;
        return storage instanceof LimitedStorage && (limitedStorage = (LimitedStorage)storage).getCapacity() > 0L && limitedStorage.getCapacity() == limitedStorage.getStored();
    }

    private boolean processResult(Result result, int index) {
        if (result.isSuccess()) {
            if (result == Result.SUCCESS && this.listener != null) {
                this.listener.onTransferSuccess(index);
            }
            return true;
        }
        return false;
    }

    private static enum Result {
        SUCCESS,
        PARTIAL,
        FAILURE;


        private boolean isSuccess() {
            return this == PARTIAL || this == SUCCESS;
        }
    }
}

