/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wireless;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.ModemState;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemPeripheral;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.util.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class WirelessModemBlockEntity
extends BlockEntity {
    private final boolean advanced;
    private final ModemPeripheral modem;
    private final TickScheduler.Token tickToken = new TickScheduler.Token(this);

    public WirelessModemBlockEntity(BlockEntityType<? extends WirelessModemBlockEntity> type, BlockPos pos, BlockState state, boolean advanced) {
        super(type, pos, state);
        this.advanced = advanced;
        this.modem = new Peripheral(this);
    }

    public void setRemoved() {
        super.setRemoved();
        this.modem.removed();
    }

    public void clearRemoved() {
        super.clearRemoved();
        TickScheduler.schedule(this.tickToken);
    }

    @Deprecated
    public void setBlockState(BlockState state) {
        Direction direction = this.getDirection();
        super.setBlockState(state);
        if (this.getDirection() != direction) {
            PlatformHelper.get().invalidateComponent(this);
        }
    }

    void blockTick() {
        if (this.modem.getModemState().pollChanged()) {
            this.updateBlockState();
        }
    }

    private Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)WirelessModemBlock.FACING);
    }

    private void updateBlockState() {
        boolean on = this.modem.getModemState().isOpen();
        BlockState state = this.getBlockState();
        if ((Boolean)state.getValue((Property)WirelessModemBlock.ON) != on) {
            this.getLevel().setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)WirelessModemBlock.ON, (Comparable)Boolean.valueOf(on)));
        }
    }

    public @Nullable IPeripheral getPeripheral(@Nullable Direction direction) {
        return direction == null || this.getDirection() == direction ? this.modem : null;
    }

    private static class Peripheral
    extends WirelessModemPeripheral {
        private final WirelessModemBlockEntity entity;

        Peripheral(WirelessModemBlockEntity entity) {
            super(new ModemState(() -> TickScheduler.schedule(entity.tickToken)), entity.advanced);
            this.entity = entity;
        }

        @Override
        public Level getLevel() {
            return this.entity.getLevel();
        }

        @Override
        public Vec3 getPosition() {
            return Vec3.atLowerCornerOf((Vec3i)this.entity.getBlockPos().relative(this.entity.getDirection()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(@Nullable IPeripheral other) {
            if (this == other) return true;
            if (!(other instanceof Peripheral)) return false;
            Peripheral o = (Peripheral)other;
            if (this.entity != o.entity) return false;
            return true;
        }

        @Override
        public Object getTarget() {
            return this.entity;
        }
    }
}

