/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities;

import com.kyanite.deeperdarker.content.DDSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class AnglerFish
extends AbstractFish {
    public final AnimationState attackState = new AnimationState();

    public AnglerFish(EntityType<? extends AbstractFish> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier createAttributesSupplier() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.MOVEMENT_SPEED, 1.5).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new AnglerFishAttackGoal(this, 1.5, true));
        this.goalSelector.addGoal(1, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 40));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this::validTarget));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, true));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, true));
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)DDSounds.ANGLER_FISH_DEATH.get();
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)DDSounds.ANGLER_FISH_FLOP.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)DDSounds.ANGLER_FISH_HURT.get();
    }

    public boolean doHurtTarget(Entity entity) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(entity);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.attackState.start(this.tickCount);
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isWithinMeleeAttackRange(LivingEntity entity) {
        return this.getAttackBoundingBox().inflate(1.0).intersects(entity.getBoundingBox());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean validTarget(LivingEntity entity) {
        return entity != null && entity.isInWater();
    }

    public static boolean checkSpawnRules(EntityType<? extends LivingEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos).is(Blocks.WATER);
    }

    public ItemStack getBucketItemStack() {
        return null;
    }

    static class AnglerFishAttackGoal
    extends MeleeAttackGoal {
        private final AnglerFish fish;

        public AnglerFishAttackGoal(AnglerFish fish, double speedModifier, boolean followIfNotSeen) {
            super((PathfinderMob)fish, speedModifier, followIfNotSeen);
            this.fish = fish;
        }

        public boolean canUse() {
            return super.canUse() && this.fish.validTarget(this.fish.getTarget());
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.fish.validTarget(this.fish.getTarget());
        }
    }
}

