/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.blockentity;

import com.refinedmods.rangedpumps.RangedPumps;
import com.refinedmods.rangedpumps.blockentity.PumpState;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class PumpBlockEntity
extends BlockEntity {
    private PumpTank tank = new PumpTank();
    private IEnergyStorage energy = new EnergyStorage(RangedPumps.SERVER_CONFIG.getEnergyCapacity());
    private int ticks;
    @Nullable
    private BlockPos currentPos;
    private int range = -1;
    private Queue<BlockPos> surfaces = new LinkedList<BlockPos>();
    private Block blockToReplaceLiquidsWith;

    public PumpBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RangedPumps.PUMP_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    private void rebuildSurfaces() {
        int i;
        this.surfaces.clear();
        if (this.range == -1) {
            this.surfaces.add(this.worldPosition.below());
            return;
        }
        int hl = 3 + 2 * this.range;
        int vl = 1 + 2 * this.range;
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.worldPosition.offset(-this.range - 1 + i, -1, -this.range - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.worldPosition.offset(-this.range - 1 + vl + 1, -1, -this.range - 1 + i + 1));
        }
        for (i = 0; i < hl; ++i) {
            this.surfaces.add(this.worldPosition.offset(-this.range - 1 + hl - i - 1, -1, -this.range - 1 + hl - 1));
        }
        for (i = 0; i < vl; ++i) {
            this.surfaces.add(this.worldPosition.offset(-this.range - 1, -1, -this.range - 1 + vl - i));
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.surfaces.isEmpty()) {
            this.rebuildSurfaces();
        }
    }

    public void tick() {
        if (this.level == null) {
            return;
        }
        if (!RangedPumps.SERVER_CONFIG.getUseEnergy()) {
            this.energy.receiveEnergy(this.energy.getMaxEnergyStored(), false);
        }
        if (!this.tank.getFluid().isEmpty()) {
            LinkedList<IFluidHandler> fluidHandlers = new LinkedList<IFluidHandler>();
            for (Direction facing : Direction.values()) {
                IFluidHandler handler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.relative(facing), (Object)facing.getOpposite());
                if (handler == null) continue;
                fluidHandlers.add(handler);
            }
            if (!fluidHandlers.isEmpty()) {
                int transfer = (int)Math.floor((float)this.tank.getFluidAmount() / (float)fluidHandlers.size());
                for (IFluidHandler fluidHandler : fluidHandlers) {
                    FluidStack toFill = this.tank.getFluid().copy();
                    toFill.setAmount(transfer);
                    this.tank.drain(fluidHandler.fill(toFill, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
        if ((RangedPumps.SERVER_CONFIG.getSpeed() == 0 || this.ticks % RangedPumps.SERVER_CONFIG.getSpeed() == 0) && this.getState() == PumpState.WORKING) {
            if (this.currentPos == null || this.currentPos.getY() == this.level.dimensionType().minY()) {
                if (this.surfaces.isEmpty()) {
                    ++this.range;
                    if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
                        return;
                    }
                    this.rebuildSurfaces();
                }
                this.currentPos = this.surfaces.poll();
            } else {
                this.currentPos = this.currentPos.below();
            }
            this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerMove(), false);
            FluidStack drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.SIMULATE);
            if (!drained.isEmpty() && this.tank.fillInternal(drained, IFluidHandler.FluidAction.SIMULATE) == drained.getAmount() && !(drained = this.drainAt(this.currentPos, IFluidHandler.FluidAction.EXECUTE)).isEmpty()) {
                this.tank.fillInternal(drained, IFluidHandler.FluidAction.EXECUTE);
                if (RangedPumps.SERVER_CONFIG.getReplaceLiquidWithBlock()) {
                    if (this.blockToReplaceLiquidsWith == null) {
                        this.blockToReplaceLiquidsWith = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)RangedPumps.SERVER_CONFIG.getBlockIdToReplaceLiquidsWith()));
                    }
                    if (this.blockToReplaceLiquidsWith != null) {
                        this.level.setBlockAndUpdate(this.currentPos, this.blockToReplaceLiquidsWith.defaultBlockState());
                    }
                }
                this.energy.extractEnergy(RangedPumps.SERVER_CONFIG.getEnergyUsagePerDrain(), false);
            }
            this.setChanged();
        }
        ++this.ticks;
    }

    @Nonnull
    private FluidStack drainAt(BlockPos pos, IFluidHandler.FluidAction action) {
        BlockState frontBlockState = this.level.getBlockState(pos);
        Block frontBlock = frontBlockState.getBlock();
        if (frontBlock instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)frontBlock;
            if ((Integer)frontBlockState.getValue((Property)LiquidBlock.LEVEL) == 0) {
                FlowingFluid fluid = liquidBlock.fluid;
                if (action == IFluidHandler.FluidAction.EXECUTE) {
                    this.level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
                }
                return new FluidStack((Fluid)fluid, 1000);
            }
        }
        return FluidStack.EMPTY;
    }

    BlockPos getCurrentPosition() {
        return this.currentPos == null ? this.worldPosition.below() : this.currentPos;
    }

    int getRange() {
        return this.range;
    }

    PumpState getState() {
        if (this.range > RangedPumps.SERVER_CONFIG.getRange()) {
            return PumpState.DONE;
        }
        if (this.level != null && this.level.hasNeighborSignal(this.worldPosition)) {
            return PumpState.REDSTONE;
        }
        if (this.energy.getEnergyStored() == 0) {
            return PumpState.ENERGY;
        }
        if (this.tank.getFluidAmount() > this.tank.getCapacity() - 1000) {
            return PumpState.FULL;
        }
        return PumpState.WORKING;
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("Energy", this.energy.getEnergyStored());
        if (this.currentPos != null) {
            tag.putLong("CurrentPos", this.currentPos.asLong());
        }
        tag.putInt("Range", this.range);
        ListTag surfaces = new ListTag();
        this.surfaces.forEach(s -> surfaces.add((Object)LongTag.valueOf((long)s.asLong())));
        tag.put("Surfaces", (Tag)surfaces);
        this.tank.writeToNBT(provider, tag);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains("Energy")) {
            this.energy.receiveEnergy(tag.getInt("Energy"), false);
        }
        if (tag.contains("CurrentPos")) {
            this.currentPos = BlockPos.of((long)tag.getLong("CurrentPos"));
        }
        if (tag.contains("Range")) {
            this.range = tag.getInt("Range");
        }
        if (tag.contains("Surfaces")) {
            ListTag surfaces = tag.getList("Surfaces", 4);
            for (Tag surface : surfaces) {
                this.surfaces.add(BlockPos.of((long)((LongTag)surface).getAsLong()));
            }
        }
        this.tank.readFromNBT(provider, tag);
    }

    private static class PumpTank
    extends FluidTank {
        public PumpTank() {
            super(RangedPumps.SERVER_CONFIG.getTankCapacity());
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
            return super.fill(resource, action);
        }
    }
}

