/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.distribution.EnergySaveTarget;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.util.EmitUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

@ParametersAreNotNullByDefault
public record ModuleChargeDistributionUnit(boolean chargeSuit, boolean chargeInventory) implements ICustomModule<ModuleChargeDistributionUnit>
{
    public static final ResourceLocation CHARGE_SUIT = Mekanism.rl("charge_suit");
    public static final ResourceLocation CHARGE_INVENTORY = Mekanism.rl("charge_inventory");

    public ModuleChargeDistributionUnit(IModule<ModuleChargeDistributionUnit> module) {
        this(module.getBooleanConfigOrFalse(CHARGE_SUIT), module.getBooleanConfigOrFalse(CHARGE_INVENTORY));
    }

    @Override
    public void tickServer(IModule<ModuleChargeDistributionUnit> module, IModuleContainer moduleContainer, ItemStack stack, Player player) {
        IEnergyContainer energyContainer;
        if (this.chargeInventory && (energyContainer = module.getEnergyContainer(stack)) != null) {
            this.chargeInventory(energyContainer, player);
        }
        if (this.chargeSuit) {
            this.chargeSuit(player);
        }
    }

    private void chargeSuit(Player player) {
        EnergySaveTarget<EnergySaveTarget.DelegateSaveHandler> saveTarget = new EnergySaveTarget<EnergySaveTarget.DelegateSaveHandler>(4);
        for (ItemStack stack : player.getArmorSlots()) {
            IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
            if (energyContainer == null) continue;
            saveTarget.addHandler(new EnergySaveTarget.DelegateSaveHandler(energyContainer));
        }
        if (saveTarget.getHandlerCount() > 1) {
            long stored = saveTarget.getStored();
            EmitUtils.sendToAcceptors(saveTarget, stored, EnergyNetwork.ENERGY);
            saveTarget.save();
        }
    }

    private void chargeInventory(IEnergyContainer energyContainer, Player player) {
        long toCharge = Math.min(MekanismConfig.gear.mekaSuitInventoryChargeRate.get(), energyContainer.getEnergy());
        if (toCharge == 0L) {
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        toCharge = this.charge(energyContainer, mainHand, toCharge);
        if ((toCharge = this.charge(energyContainer, offHand, toCharge)) > 0L) {
            IItemHandler handler;
            for (ItemStack stack : player.getInventory().items) {
                if (stack == mainHand || stack == offHand || (toCharge = this.charge(energyContainer, stack, toCharge)) != 0L) continue;
                return;
            }
            if (Mekanism.hooks.curios.isLoaded() && (handler = CuriosIntegration.getCuriosInventory((LivingEntity)player)) != null) {
                int slots = handler.getSlots();
                for (int slot = 0; slot < slots; ++slot) {
                    toCharge = this.charge(energyContainer, handler.getStackInSlot(slot), toCharge);
                    if (toCharge != 0L) continue;
                    return;
                }
            }
        }
    }

    private long charge(IEnergyContainer energyContainer, ItemStack stack, long amount) {
        long remaining;
        IStrictEnergyHandler handler;
        if (!stack.isEmpty() && amount > 0L && (handler = EnergyCompatUtils.getStrictEnergyHandler(stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)) < amount) {
            long toExtract = amount - remaining;
            long extracted = energyContainer.extract(toExtract, Action.EXECUTE, AutomationType.MANUAL);
            long inserted = handler.insertEnergy(extracted, Action.EXECUTE);
            return inserted + remaining;
        }
        return amount;
    }
}

