/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base.holiday;

import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import mekanism.api.robit.RobitSkin;
import mekanism.common.Mekanism;
import mekanism.common.base.holiday.AprilFools;
import mekanism.common.base.holiday.Christmas;
import mekanism.common.base.holiday.Holiday;
import mekanism.common.base.holiday.May4;
import mekanism.common.base.holiday.NewYear;
import mekanism.common.base.holiday.Pride;
import mekanism.common.base.holiday.YearlyDate;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registration.impl.SoundEventRegistryObject;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public final class HolidayManager {
    private static final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "HolidayManager Day Checker");
        t.setDaemon(true);
        return t;
    });
    private static final Set<Holiday> holidays = Set.of(Christmas.INSTANCE, NewYear.INSTANCE, May4.INSTANCE, AprilFools.INSTANCE, Pride.INSTANCE);
    private static final Map<Holder<SoundEvent>, Supplier<SoundEvent>> filterableSounds = new HashMap<Holder<SoundEvent>, Supplier<SoundEvent>>();
    private static boolean holidaysNotified = false;
    @Nullable
    private static IRobitSkinRandomizerHoliday robitSkinHoliday;
    @Nullable
    private static IFilterableSoundHoliday soundHoliday;

    private HolidayManager() {
    }

    public static boolean areHolidaysEnabled() {
        return MekanismConfig.common.holidays.get();
    }

    public static void init() {
        timer.scheduleAtFixedRate(HolidayManager::updateToday, LocalTime.now().until(LocalTime.MIDNIGHT, ChronoUnit.MILLIS), TimeUnit.DAYS.toMillis(1L), TimeUnit.MILLISECONDS);
        HolidayManager.updateToday();
        for (Holiday holiday : holidays) {
            if (!(holiday instanceof IFilterableSoundHoliday)) continue;
            IFilterableSoundHoliday filterableSoundHoliday = (IFilterableSoundHoliday)((Object)holiday);
            for (Holder<SoundEvent> soundEvent : filterableSoundHoliday.getFilterableSounds().keySet()) {
                filterableSounds.computeIfAbsent(soundEvent, sound -> () -> {
                    if (HolidayManager.areHolidaysEnabled() && soundHoliday != null) {
                        return (SoundEvent)soundHoliday.getFilterableSounds().getOrDefault(sound, (Holder<SoundEvent>)sound).value();
                    }
                    return (SoundEvent)sound.value();
                });
            }
        }
        Mekanism.logger.info("Initialized HolidayManager.");
    }

    private static void updateToday() {
        holidaysNotified = false;
        robitSkinHoliday = null;
        soundHoliday = null;
        YearlyDate date = YearlyDate.now();
        for (Holiday holiday : holidays) {
            IFilterableSoundHoliday filterableSoundHoliday;
            if (!holiday.updateIsToday(date)) continue;
            if (robitSkinHoliday == null && holiday instanceof IRobitSkinRandomizerHoliday) {
                IRobitSkinRandomizerHoliday randomizerHoliday;
                robitSkinHoliday = randomizerHoliday = (IRobitSkinRandomizerHoliday)((Object)holiday);
            }
            if (soundHoliday != null || !(holiday instanceof IFilterableSoundHoliday)) continue;
            soundHoliday = filterableSoundHoliday = (IFilterableSoundHoliday)((Object)holiday);
        }
    }

    public static void notify(Player player) {
        if (!holidaysNotified) {
            holidaysNotified = true;
            if (HolidayManager.areHolidaysEnabled()) {
                for (Holiday holiday : holidays) {
                    if (!holiday.isToday() || holiday.hasNotified()) continue;
                    holiday.notify(player);
                }
            }
        }
    }

    public static Supplier<SoundEvent> filterSound(SoundEventRegistryObject<SoundEvent> sound) {
        return (Supplier)((Object)filterableSounds.getOrDefault(sound, (Supplier<SoundEvent>)((Object)sound)));
    }

    public static ResourceKey<RobitSkin> getRandomBaseSkin(RandomSource random) {
        if (HolidayManager.areHolidaysEnabled() && robitSkinHoliday != null) {
            return robitSkinHoliday.randomBaseSkin(random);
        }
        return MekanismRobitSkins.BASE;
    }

    public static boolean hasRobitSkinsToday() {
        return HolidayManager.areHolidaysEnabled() && robitSkinHoliday != null;
    }

    static interface IFilterableSoundHoliday {
        public Map<Holder<SoundEvent>, Holder<SoundEvent>> getFilterableSounds();
    }

    static interface IRobitSkinRandomizerHoliday {
        public ResourceKey<RobitSkin> randomBaseSkin(RandomSource var1);
    }
}

