/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.item.PortableQIODashboardContainer;
import mekanism.common.lib.frequency.FrequencyManager;
import mekanism.common.lib.multiblock.MultiblockManager;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.util.WorldUtils;
import mekanism.common.world.GenHandler;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;

public class CommonWorldTickHandler {
    private static final long maximumDeltaTimeNanoSecs = 16000000L;
    private Map<ResourceLocation, Object2IntMap<ChunkPos>> chunkVersions;
    private Map<ResourceLocation, Queue<ChunkPos>> chunkRegenMap;
    public static boolean flushTagAndRecipeCaches;
    public static boolean monitoringCardboardBox;
    @Nullable
    public static Predicate<ItemStack> fallbackItemCollector;

    public void addRegenChunk(ResourceKey<Level> dimension, ChunkPos chunkCoord) {
        ResourceLocation dimensionName;
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new Object2ObjectArrayMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionName = dimension.location())) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionName, list);
        } else {
            Queue<ChunkPos> regenPositions = this.chunkRegenMap.get(dimensionName);
            if (!regenPositions.contains(chunkCoord)) {
                regenPositions.add(chunkCoord);
            }
        }
    }

    public void resetChunkData() {
        this.chunkRegenMap = null;
        this.chunkVersions = null;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySpawn(EntityJoinLevelEvent event) {
        ItemEntity entity;
        Entity entity2;
        if (monitoringCardboardBox) {
            Entity entity3 = event.getEntity();
            if (entity3 instanceof ItemEntity || entity3 instanceof ExperienceOrb) {
                entity3.discard();
                event.setCanceled(true);
            }
        } else if (!event.getLevel().isClientSide && fallbackItemCollector != null && (entity2 = event.getEntity()) instanceof ItemEntity && fallbackItemCollector.test((entity = (ItemEntity)entity2).getItem())) {
            entity.discard();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor;
        BlockState state = event.getState();
        if (state != null && !state.isAir() && (levelAccessor = event.getLevel()) instanceof Level) {
            Level level = (Level)levelAccessor;
            if (!IBlockSecurityUtils.INSTANCE.canAccess(event.getPlayer(), level, event.getPos())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public synchronized void chunkSave(ChunkDataEvent.Save event) {
        LevelAccessor world = event.getLevel();
        if (!world.isClientSide() && world instanceof Level) {
            Level level = (Level)world;
            int chunkVersion = MekanismConfig.world.userGenVersion.get();
            if (this.chunkVersions != null) {
                chunkVersion = this.chunkVersions.getOrDefault(level.dimension().location(), (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap()).getOrDefault((Object)event.getChunk().getPos(), chunkVersion);
            }
            event.getData().putInt("mek_world_gen_version", chunkVersion);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        int version;
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).isClientSide() && (version = event.getData().getInt("mek_world_gen_version")) < MekanismConfig.world.userGenVersion.get()) {
            if (this.chunkVersions == null) {
                this.chunkVersions = new Object2ObjectArrayMap();
            }
            ChunkPos chunkCoord = event.getChunk().getPos();
            ResourceKey dimension = level.dimension();
            this.chunkVersions.computeIfAbsent(dimension.location(), dim -> new Object2IntOpenHashMap()).put((Object)chunkCoord, version);
            if (MekanismConfig.world.enableRegeneration.get()) {
                this.addRegenChunk((ResourceKey<Level>)dimension, chunkCoord);
            }
        }
    }

    @SubscribeEvent
    public void chunkUnloadEvent(ChunkEvent.Unload event) {
        Level level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && !(level = (Level)levelAccessor).isClientSide() && this.chunkVersions != null) {
            this.chunkVersions.getOrDefault(level.dimension().location(), (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap()).removeInt((Object)event.getChunk().getPos());
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (!world.isClientSide() && world instanceof Level) {
            Level level = (Level)world;
            if (this.chunkVersions != null) {
                this.chunkVersions.remove(level.dimension().location());
            }
        }
    }

    @SubscribeEvent
    public void worldLoadEvent(LevelEvent.Load event) {
        if (!event.getLevel().isClientSide()) {
            FrequencyManager.load();
            MultiblockManager.createOrLoadAll();
            QIOGlobalItemLookup.INSTANCE.createOrLoad();
        }
    }

    @SubscribeEvent
    public void onTick(ServerTickEvent.Post event) {
        boolean tickingNormally = event.getServer().tickRateManager().runsNormally();
        FrequencyManager.tick(tickingNormally);
    }

    @SubscribeEvent
    public void onTick(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            RadiationManager.get().tickServerWorld(world);
            if (flushTagAndRecipeCaches) {
                for (ServerPlayer player : world.players()) {
                    AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                    if (!(abstractContainerMenu instanceof PortableQIODashboardContainer)) continue;
                    PortableQIODashboardContainer qioDashboard = (PortableQIODashboardContainer)abstractContainerMenu;
                    for (int index = 0; index < 3; index = (int)((byte)(index + 1))) {
                        qioDashboard.getCraftingWindow(index).invalidateRecipe();
                    }
                }
                flushTagAndRecipeCaches = false;
            }
            if (this.chunkRegenMap == null || !MekanismConfig.world.enableRegeneration.get()) {
                return;
            }
            ResourceLocation dimensionName = world.dimension().location();
            if (this.chunkRegenMap.containsKey(dimensionName)) {
                ChunkPos nextChunk;
                Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionName);
                Object2IntMap<ChunkPos> dimensionChunkVersions = this.chunkVersions == null ? Object2IntMaps.emptyMap() : this.chunkVersions.getOrDefault(dimensionName, (Object2IntMap<ChunkPos>)Object2IntMaps.emptyMap());
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                    if (!WorldUtils.isChunkLoaded((LevelReader)world, nextChunk)) continue;
                    if (GenHandler.generate(world, nextChunk)) {
                        Mekanism.logger.info("Regenerating ores and salt at chunk {}", (Object)nextChunk);
                    }
                    if (this.chunkVersions == null) continue;
                    dimensionChunkVersions.removeInt((Object)nextChunk);
                }
                if (chunksToGen.isEmpty()) {
                    this.chunkRegenMap.remove(dimensionName);
                }
            }
        }
    }
}

