/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.inputs;

import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class InputHelper {
    private InputHelper() {
    }

    public static IInputHandler<@NotNull ItemStack> getInputHandler(final IInventorySlot slot, final CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(slot, "Slot cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new IInputHandler<ItemStack>(){

            @Override
            public ItemStack getInput() {
                return slot.getStack();
            }

            @Override
            public ItemStack getRecipeInput(InputIngredient<@NotNull ItemStack> recipeIngredient) {
                ItemStack input = this.getInput();
                if (input.isEmpty()) {
                    return ItemStack.EMPTY;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(ItemStack recipeInput, int operations) {
                if (operations == 0) {
                    return;
                }
                if (!recipeInput.isEmpty()) {
                    int amount = recipeInput.getCount() * operations;
                    InputHelper.logMismatchedStackSize(slot.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ItemStack recipeInput, int usageMultiplier) {
                if (usageMultiplier > 0) {
                    int operations;
                    if (!recipeInput.isEmpty() && (operations = this.getInput().getCount() / (recipeInput.getCount() * usageMultiplier)) > 0) {
                        tracker.updateOperations(operations);
                        return;
                    }
                    tracker.resetProgress(notEnoughError);
                }
            }
        };
    }

    public static ILongInputHandler<@NotNull ChemicalStack> getInputHandler(IChemicalTank tank, CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new ChemicalInputHandler(tank, notEnoughError);
    }

    public static ILongInputHandler<@NotNull ChemicalStack> getConstantInputHandler(IChemicalTank tank) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        return new ChemicalInputHandler(tank, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT){

            @Override
            protected void resetProgress(CachedRecipe.OperationTracker tracker) {
                tracker.updateOperations(0);
            }
        };
    }

    public static IInputHandler<@NotNull FluidStack> getInputHandler(final IExtendedFluidTank tank, final CachedRecipe.OperationTracker.RecipeError notEnoughError) {
        Objects.requireNonNull(tank, "Tank cannot be null.");
        Objects.requireNonNull(notEnoughError, "Not enough input error cannot be null.");
        return new IInputHandler<FluidStack>(){

            @Override
            @NotNull
            public FluidStack getInput() {
                return tank.getFluid();
            }

            @Override
            @NotNull
            public FluidStack getRecipeInput(InputIngredient<@NotNull FluidStack> recipeIngredient) {
                FluidStack input = this.getInput();
                if (input.isEmpty()) {
                    return FluidStack.EMPTY;
                }
                return recipeIngredient.getMatchingInstance(input);
            }

            @Override
            public void use(FluidStack recipeInput, int operations) {
                if (operations == 0 || recipeInput.isEmpty()) {
                    return;
                }
                FluidStack inputFluid = this.getInput();
                if (!inputFluid.isEmpty()) {
                    int amount = recipeInput.getAmount() * operations;
                    InputHelper.logMismatchedStackSize(tank.shrinkStack(amount, Action.EXECUTE), amount);
                }
            }

            @Override
            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, FluidStack recipeInput, int usageMultiplier) {
                if (usageMultiplier > 0) {
                    int operations;
                    if (!recipeInput.isEmpty() && (operations = this.getInput().getAmount() / (recipeInput.getAmount() * usageMultiplier)) > 0) {
                        tracker.updateOperations(operations);
                        return;
                    }
                    tracker.resetProgress(notEnoughError);
                }
            }
        };
    }

    private static void logMismatchedStackSize(long actual, long expected) {
        if (expected != actual) {
            MekanismAPI.logger.error("Stack size changed by a different amount ({}) than requested ({}).", new Object[]{actual, expected, new Exception()});
        }
    }

    private static class ChemicalInputHandler
    implements ILongInputHandler<ChemicalStack> {
        private final IChemicalTank tank;
        private final CachedRecipe.OperationTracker.RecipeError notEnoughError;

        private ChemicalInputHandler(IChemicalTank tank, CachedRecipe.OperationTracker.RecipeError notEnoughError) {
            this.tank = tank;
            this.notEnoughError = notEnoughError;
        }

        @Override
        public ChemicalStack getInput() {
            return this.tank.getStack();
        }

        @Override
        public ChemicalStack getRecipeInput(InputIngredient<ChemicalStack> recipeIngredient) {
            ChemicalStack input = this.getInput();
            if (input.isEmpty()) {
                return ChemicalStack.EMPTY;
            }
            return recipeIngredient.getMatchingInstance(input);
        }

        @Override
        public void use(ChemicalStack recipeInput, long operations) {
            if (operations == 0L || recipeInput.isEmpty()) {
                return;
            }
            ChemicalStack inputChemical = this.getInput();
            if (!inputChemical.isEmpty()) {
                long amount = recipeInput.getAmount() * operations;
                InputHelper.logMismatchedStackSize(this.tank.shrinkStack(amount, Action.EXECUTE), amount);
            }
        }

        @Override
        public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, ChemicalStack recipeInput, long usageMultiplier) {
            if (usageMultiplier > 0L) {
                int operations;
                if (!recipeInput.isEmpty() && (operations = MathUtils.clampToInt(this.getInput().getAmount() / (recipeInput.getAmount() * usageMultiplier))) > 0) {
                    tracker.updateOperations(operations);
                    return;
                }
                this.resetProgress(tracker);
            }
        }

        protected void resetProgress(CachedRecipe.OperationTracker tracker) {
            tracker.resetProgress(this.notEnoughError);
        }
    }
}

