/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.summon;

import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreathAirGoal;
import net.minecraft.world.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SummonDolphin
extends Dolphin
implements PlayerRideableJumping,
ISummon {
    public int ticksLeft;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(SummonDolphin.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);

    public SummonDolphin(EntityType<? extends Dolphin> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SummonDolphin(Level world) {
        this((EntityType<? extends Dolphin>)((EntityType)ModEntities.DOLPHIN_SUMMON.get()), world);
    }

    public SummonDolphin(SummonHorse oldHorse, Player summoner) {
        this(summoner.level());
        BlockPos position = oldHorse.blockPosition();
        this.setPos(position.getX(), position.getY(), position.getZ());
        this.ticksLeft = oldHorse.getTicksLeft();
        this.setOwnerID(summoner.getUUID());
        oldHorse.getActiveEffects().stream().filter(e -> ((MobEffect)e.getEffect().value()).isBeneficial()).forEach(arg_0 -> ((SummonDolphin)this).addEffect(arg_0));
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.DOLPHIN_SUMMON.get();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new BreathAirGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(5, (Goal)new DolphinJumpGoal((Dolphin)this, 10));
        this.goalSelector.addGoal(8, (Goal)new FollowBoatGoal((PathfinderMob)this));
    }

    protected void positionRider(@NotNull Entity passenger, Entity.MoveFunction callback) {
        Vec3 vec3 = this.getPassengerRidingPosition(passenger);
        Vec3 vec31 = passenger.getVehicleAttachmentPoint((Entity)this);
        callback.accept(passenger, vec3.x - vec31.x, vec3.y - vec31.y, vec3.z - vec31.z);
        if (passenger instanceof Mob) {
            Mob mob = (Mob)passenger;
            if (this.getControllingPassenger() == passenger) {
                this.yBodyRot = mob.yBodyRot;
            }
        }
    }

    public LivingEntity getControllingPassenger() {
        Entity entity = this.getFirstPassenger();
        if (entity instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    protected boolean canRide(@NotNull Entity pEntity) {
        return pEntity instanceof Player;
    }

    @NotNull
    public InteractionResult mobInteract(Player player, @NotNull InteractionHand hand) {
        if (player.level().isClientSide()) {
            return InteractionResult.PASS;
        }
        if (player.getMainHandItem().isEmpty() && !player.isShiftKeyDown()) {
            player.startRiding((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void travel(@NotNull Vec3 pTravelVector) {
        if (this.isAlive()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.isVehicle() && livingentity != null) {
                this.setYRot(livingentity.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(livingentity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float strafe = livingentity.xxa * 0.5f;
                float forward = livingentity.zza * 2.0f;
                if (forward <= 0.0f) {
                    forward *= 0.25f;
                }
                if (this.isControlledByLocalInstance()) {
                    if (this.getMoistnessLevel() <= 2350) {
                        this.setSpeed((float)Math.min((double)this.getSpeed(), this.getAttributeValue(Attributes.MOVEMENT_SPEED) + 0.5));
                    }
                    if (this.isInWater()) {
                        this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) + 2.5f);
                        float vert = (float)(pTravelVector.y - 0.4 * (0.2 + (double)livingentity.getXRot()));
                        super.travel(new Vec3((double)strafe, (double)vert + 0.5, (double)forward));
                    } else {
                        super.travel(new Vec3((double)strafe, pTravelVector.y, (double)forward));
                    }
                } else if (livingentity instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
            } else {
                super.travel(pTravelVector);
            }
        }
    }

    protected float getWaterSlowDown() {
        return 0.975f;
    }

    protected void customServerAiStep() {
        LivingEntity livingEntity;
        if (this.isVehicle() && (livingEntity = this.getControllingPassenger()) instanceof Player) {
            Player player = (Player)livingEntity;
            player.setAirSupply(player.getMaxAirSupply());
        }
    }

    public int getBaseExperienceReward() {
        return 0;
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder entityData) {
        super.defineSynchedData(entityData);
        entityData.define(OWNER_UUID, Optional.of(Util.NIL_UUID));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            --this.ticksLeft;
            if (this.ticksLeft <= 0) {
                ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
                this.remove(Entity.RemovalReason.DISCARDED);
                this.onSummonDeath(this.level(), null, true);
            }
        }
    }

    public void die(@NotNull DamageSource cause) {
        super.die(cause);
        this.onSummonDeath(this.level(), cause, false);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.ticksLeft = compound.getInt("left");
        UUID uuid = null;
        if (compound.hasUUID("owner")) {
            uuid = compound.getUUID("owner");
        }
        if (uuid != null) {
            this.setOwnerID(uuid);
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("left", this.ticksLeft);
        this.writeOwner(compound);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void setTicksLeft(int ticks) {
        this.ticksLeft = ticks;
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.getEntityData().get(OWNER_UUID)).isEmpty() ? this.getUUID() : (UUID)((Optional)this.getEntityData().get(OWNER_UUID)).get();
    }

    public void setOwnerID(UUID uuid) {
        this.getEntityData().set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void onPlayerJump(int pJumpPower) {
    }

    public boolean canJump() {
        return this.isInWater() || this.getMoistnessLevel() > 2300;
    }

    public void handleStartJump(int pJumpPower) {
        if (pJumpPower < 50) {
            return;
        }
        Direction direction = this.getMotionDirection();
        if (this.getControllingPassenger() != null && this.getControllingPassenger().getXRot() > 20.0f) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)direction.getStepX(), -1.5, (double)direction.getStepZ()).scale((double)(0.7f * (float)pJumpPower / 10.0f)));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().add((double)direction.getStepX(), 1.5, (double)direction.getStepZ()).scale((double)(0.7f * (float)pJumpPower / 10.0f)));
        }
    }

    public void handleStopJump() {
    }
}

