/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.registry.ModEntities;
import com.alexthw.sauce.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.BaseProperty;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.IPropertyType;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.WallProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.LingerTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineMap;
import com.hollingsworth.arsnouveau.api.registry.ParticlePropertyRegistry;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.common.entity.EntityLingeringSpell;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityMagnetSpell
extends EntityProjectileSpell {
    List<Predicate<Entity>> ignored;
    public static final EntityDataAccessor<Float> DURATION_UP = SynchedEntityData.defineId(EntityMagnetSpell.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> AOE = SynchedEntityData.defineId(EntityMagnetSpell.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    LivingEntity tracked;

    public EntityMagnetSpell(EntityType<? extends EntityProjectileSpell> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityMagnetSpell(Level worldIn) {
        super((EntityType)ModEntities.LINGER_MAGNET.get(), worldIn);
    }

    public static EntityMagnetSpell createMagnet(Level world, LivingEntity shooter, SpellStats spellStats, SpellResolver spellResolver, Vec3 location) {
        EntityMagnetSpell magnet = new EntityMagnetSpell(world);
        SpellContext spellContext = spellResolver.spellContext;
        magnet.ignored = EntityMagnetSpell.makeIgnores(shooter, spellContext.getSpell(), spellContext.getCurrentIndex() + 1);
        magnet.setPos(location);
        magnet.setAoe((float)spellStats.getAoeMultiplier());
        magnet.setOwner((Entity)shooter);
        magnet.setExtendedTime(spellStats.getDurationMultiplier());
        magnet.setResolver(spellResolver);
        return magnet;
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)ModEntities.LINGER_MAGNET.get();
    }

    public float getAoe() {
        return 3.0f + ((Float)this.entityData.get(AOE)).floatValue();
    }

    public void setAoe(float aoe) {
        this.entityData.set(AOE, (Object)Float.valueOf(aoe));
    }

    public void tickNextPosition() {
        if (this.tracked != null) {
            this.setPos(this.tracked.getX(), this.tracked.getY(), this.tracked.getZ());
        }
    }

    public float getExtendedTime() {
        return ((Float)this.entityData.get(DURATION_UP)).floatValue();
    }

    private void setExtendedTime(double durationMultiplier) {
        this.entityData.set(DURATION_UP, (Object)Float.valueOf((float)durationMultiplier));
    }

    public int getExpirationTime() {
        return 70 + (int)(this.getExtendedTime() * 200.0f);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide() && this.age % 5 == 0) {
            for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.blockPosition()).inflate((double)this.getAoe()))) {
                Vec3 vec3d;
                if (this.testFilters(entity) || (vec3d = new Vec3(this.getX() - entity.getX(), this.getY() - entity.getY(), this.getZ() - entity.getZ())).length() < 1.0) continue;
                entity.setDeltaMovement(entity.getDeltaMovement().add(vec3d.normalize()).scale(0.5));
                entity.hurtMarked = true;
            }
        }
    }

    public void buildEmitters() {
        TimelineMap timelineMap = this.resolver().spell.particleTimeline();
        LingerTimeline projectileTimeline = (LingerTimeline)timelineMap.get((IParticleTimelineType)ArsNouveauRegistry.GRAVITY_TIMELINE.get());
        TimelineEntryData trailConfig = projectileTimeline.trailEffect;
        TimelineEntryData resolveConfig = projectileTimeline.onResolvingEffect;
        this.tickEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityMagnetSpell)this).getRotationVector(), trailConfig);
        this.resolveEmitter = new ParticleEmitter(() -> this.getPosition(ClientInfo.partialTicks), () -> ((EntityMagnetSpell)this).getRotationVector(), resolveConfig);
        PropertyParticleOptions propertyParticleOptions = this.tickEmitter.particleOptions;
        if (propertyParticleOptions instanceof PropertyParticleOptions) {
            PropertyParticleOptions propertyParticleOptions2 = propertyParticleOptions;
            propertyParticleOptions2.map.set((IPropertyType)ParticlePropertyRegistry.WALL_PROPERTY.get(), (BaseProperty)new WallProperty(Math.round(this.getAoe()), 5, 20, this.getDirection()));
        }
        this.resolveSound = projectileTimeline.resolveSound.sound;
    }

    public boolean testFilters(Entity entity) {
        return this.ignored.stream().anyMatch(filter -> entity == this.tracked || filter.test(entity));
    }

    public static List<Predicate<Entity>> makeIgnores(LivingEntity shooter, Spell spell, int index) {
        ArrayList<Predicate<Entity>> ignore = new ArrayList<Predicate<Entity>>();
        ignore.add(entity -> entity instanceof EntityLingeringSpell);
        ignore.add(entity -> entity == shooter);
        ignore.add(entity -> entity instanceof FamiliarEntity);
        ignore.add(arg_0 -> ((LivingEntity)shooter).isAlliedTo(arg_0));
        Set filters = GlyphEffectUtil.getFilters((List)spell.unsafeList(), (int)index);
        if (!filters.isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters((Entity)entity, (Set)filters));
        }
        return ignore;
    }

    public void setTracked(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            this.tracked = livingEntity = (LivingEntity)entity;
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DURATION_UP, (Object)Float.valueOf(0.0f));
        pBuilder.define(AOE, (Object)Float.valueOf(0.0f));
    }

    public void traceAnyHit(@Nullable HitResult raytraceresult, Vec3 thisPosition, Vec3 nextPosition) {
    }

    public int getParticleDelay() {
        return 0;
    }
}

