/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.upstream;

import com.hollingsworth.arsnouveau.api.source.ISpecialSourceProvider;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.ITickable;
import com.hollingsworth.arsnouveau.common.block.tile.ModdedTile;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public abstract class UpstreamTile
extends ModdedTile
implements ITickable {
    public boolean disabled;

    public UpstreamTile(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public abstract void elevatorParticles(Entity var1, ServerLevel var2);

    public void tick() {
        List source;
        ServerLevel serverLevel;
        block9: {
            block8: {
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block8;
                serverLevel = (ServerLevel)level;
                if (!this.disabled) break block9;
            }
            return;
        }
        if (serverLevel.getGameTime() % (long)this.getTickRate() != 0L) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        if (serverLevel.getBlockState(pos.above()) == this.getBlockState()) {
            return;
        }
        int power = 1;
        while (serverLevel.getBlockState(pos.below(power)).getBlock() == this.getBlockState().getBlock()) {
            ++power;
        }
        AABB area = new AABB(pos.getCenter(), pos.above(46 * power).getCenter()).inflate(1.5);
        List entities = serverLevel.getEntitiesOfClass(LivingEntity.class, area, this::isValidTarget);
        int sourceCost = this.getSourceCost(power);
        if (!(entities.isEmpty() || sourceCost <= 0 || (source = SourceUtil.takeSourceMultiple((BlockPos)pos, (Level)serverLevel, (int)10, (int)sourceCost)) != null && !source.isEmpty() && source.stream().allMatch(ISpecialSourceProvider::isValid))) {
            return;
        }
        for (LivingEntity entity : entities) {
            this.applyEffects(serverLevel, entity);
        }
    }

    protected int getTickRate() {
        return 2;
    }

    protected abstract boolean isValidTarget(LivingEntity var1);

    protected abstract int getSourceCost(int var1);

    protected abstract void applyEffects(ServerLevel var1, LivingEntity var2);

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.disabled = tag.getBoolean("disabled");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("disabled", this.disabled);
    }
}

