/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common;

import alexthw.ars_elemental.common.items.CurioHolder;
import alexthw.ars_elemental.registry.ModRegistry;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerCopySlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CurioHolderContainer
extends AbstractContainerMenu {
    private final IItemHandler inventory;

    public CurioHolderContainer(int windowId, Inventory playerInv, ItemStack backpack) {
        this((MenuType<? extends CurioHolderContainer>)((MenuType)ModRegistry.CURIO_HOLDER.get()), windowId, playerInv, (IItemHandler)backpack.getCapability(Capabilities.ItemHandler.ITEM), backpack);
    }

    public CurioHolderContainer(MenuType<? extends CurioHolderContainer> containerType, int windowId, Inventory playerInv, @Nullable IItemHandler inventory, final ItemStack backpack) {
        super(containerType, windowId);
        this.inventory = inventory;
        if (inventory == null) {
            return;
        }
        int i = 0;
        while ((float)i < (float)inventory.getSlots() / 9.0f) {
            for (int j = 0; j < 9; ++j) {
                int index = i * 9 + j;
                this.addSlot(this.makeSlot(inventory, i, j, index));
            }
            ++i;
        }
        int offset = this.offset();
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot(this, (Container)playerInv, j1 + (l + 1) * 9, 8 + j1 * 18, offset + 84 + l * 18){

                    public boolean mayPickup(@NotNull Player playerIn) {
                        if (this.getItem().is(backpack.getItem())) {
                            return false;
                        }
                        return super.mayPickup(playerIn);
                    }
                });
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot(this, (Container)playerInv, i1, 8 + i1 * 18, offset + 142){

                public boolean mayPickup(@NotNull Player playerIn) {
                    if (this.getItem().is(backpack.getItem())) {
                        return false;
                    }
                    return super.mayPickup(playerIn);
                }
            });
        }
    }

    @NotNull
    protected Slot makeSlot(IItemHandler inventory, int i, int j, int index) {
        return new ItemHandlerCopySlot(this, inventory, index, 8 + j * 18, 18 + i * 18){

            public boolean mayPlace(@NotNull ItemStack stack) {
                return CurioHolder.canStore(stack);
            }
        };
    }

    public void removed(Player playerIn) {
        playerIn.level().playSound(null, playerIn.blockPosition(), (SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        super.removed(playerIn);
    }

    public int offset() {
        return 0;
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack quickMoveStack(@NotNull Player playerIn, int index) {
        ItemStack copy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack = slot.getItem();
            copy = itemstack.copy();
            if (index < this.inventory.getSlots() ? !this.moveItemStackTo(itemstack, this.inventory.getSlots(), this.slots.size(), true) : !this.moveItemStackTo(itemstack, 0, this.inventory.getSlots(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return copy;
    }
}

