/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.client.summons;

import alexthw.ars_elemental.ArsElemental;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import org.jetbrains.annotations.NotNull;

public class DireWolfRenderer
extends MobRenderer<Wolf, WolfModel<Wolf>> {
    static final ResourceLocation DireWolfTexture = ArsElemental.prefix("textures/entity/direwolf.png");

    public DireWolfRenderer(EntityRendererProvider.Context p_174452_) {
        super(p_174452_, (EntityModel)new WolfModel(p_174452_.bakeLayer(ModelLayers.WOLF)), 0.5f);
    }

    protected float getBob(Wolf pLivingBase, float pPartialTicks) {
        return pLivingBase.getTailAngle();
    }

    public void render(Wolf pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        if (pEntity.isWet()) {
            float f = pEntity.getWetShade(pPartialTicks);
            ((WolfModel)this.model).setColor(FastColor.ARGB32.colorFromFloat((float)1.0f, (float)f, (float)f, (float)f));
        }
        super.render((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        if (pEntity.isWet()) {
            ((WolfModel)this.model).setColor(-1);
        }
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Wolf entity) {
        return DireWolfTexture;
    }

    protected void scale(@NotNull Wolf pLivingEntity, @NotNull PoseStack pMatrixStack, float pPartialTickTime) {
        super.scale((LivingEntity)pLivingEntity, pMatrixStack, pPartialTickTime);
        pMatrixStack.scale(1.2f, 1.3f, 1.4f);
    }
}

