/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.utils.shapes.ShapeUtils;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkBlock;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CatwalkStairsBlock
extends CatwalkBlock {
    public static BooleanProperty RAILING_LEFT = BooleanProperty.create((String)"railing_left");
    public static BooleanProperty RAILING_RIGHT = BooleanProperty.create((String)"railing_right");
    private static final CachedVoxelShapes<RailingsKey> SHAPES = new CachedVoxelShapes<RailingsKey>(railingsKey -> {
        double height;
        ArrayList<AABB> list = new ArrayList<AABB>();
        list.add(ShapeUtils.transformAABB(new AABB(0.0, 0.0, 0.5, 1.0, 0.125, 1.0), railingsKey.direction));
        list.add(ShapeUtils.transformAABB(new AABB(0.0, 0.5, 0.0, 1.0, 0.625, 0.5), railingsKey.direction));
        double d = height = railingsKey.collision ? 1.5 : 1.0;
        if (railingsKey.left()) {
            list.add(ShapeUtils.transformAABB(new AABB(0.0, 0.0, 0.5, 0.0625, height, 1.0), railingsKey.direction));
            list.add(ShapeUtils.transformAABB(new AABB(0.0, 0.5, 0.0, 0.0625, height + 0.5, 0.5), railingsKey.direction));
        }
        if (railingsKey.right()) {
            list.add(ShapeUtils.transformAABB(new AABB(0.9375, 0.0, 0.5, 1.0, height, 1.0), railingsKey.direction));
            list.add(ShapeUtils.transformAABB(new AABB(0.9375, 0.5, 0.0, 1.0, height + 0.5, 0.5), railingsKey.direction));
        }
        return list;
    });

    public CatwalkStairsBlock(BlockBehaviour.Properties blockProps, boolean isDyeable) {
        super(blockProps, isDyeable);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DYE_PROPERTY, BlockStateProperties.WATERLOGGED, IEProperties.FACING_HORIZONTAL, RAILING_LEFT, RAILING_RIGHT});
    }

    @Override
    protected BlockState getInitDefaultState() {
        BlockState ret = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)Direction.NORTH)).setValue((Property)RAILING_LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RAILING_RIGHT, (Comparable)Boolean.valueOf(false));
        if (this.isDyeable) {
            ret = (BlockState)ret.setValue((Property)DYE_PROPERTY, (Comparable)DyeColor.WHITE);
        }
        return ret;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)context.getHorizontalDirection());
    }

    @Override
    public InteractionResult useHammer(BlockState state, Level world, BlockPos pos, @Nullable Player player, UseOnContext context) {
        Direction currentDirection = (Direction)state.getValue((Property)IEProperties.FACING_HORIZONTAL);
        if (player != null && player.isShiftKeyDown()) {
            Vec3 hitVec = context.getClickLocation().subtract(Vec3.atCenterOf((Vec3i)pos));
            BooleanProperty railing = switch (currentDirection) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP, Direction.NORTH -> {
                    if (hitVec.x < 0.0) {
                        yield RAILING_LEFT;
                    }
                    yield RAILING_RIGHT;
                }
                case Direction.SOUTH -> {
                    if (hitVec.x < 0.0) {
                        yield RAILING_RIGHT;
                    }
                    yield RAILING_LEFT;
                }
                case Direction.WEST -> {
                    if (hitVec.z < 0.0) {
                        yield RAILING_RIGHT;
                    }
                    yield RAILING_LEFT;
                }
                case Direction.EAST -> hitVec.z < 0.0 ? RAILING_LEFT : RAILING_RIGHT;
            };
            world.setBlock(pos, (BlockState)state.setValue((Property)railing, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)railing) == false)), 3);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction currentDirection = (Direction)state.getValue((Property)IEProperties.FACING_HORIZONTAL);
        Direction newDirection = rotation.rotate(currentDirection);
        return (BlockState)state.setValue((Property)IEProperties.FACING_HORIZONTAL, (Comparable)newDirection);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(new RailingsKey(state, false));
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(new RailingsKey(state, true));
    }

    private record RailingsKey(Direction direction, boolean left, boolean right, boolean collision) {
        public RailingsKey(BlockState blockState, boolean collision) {
            this((Direction)blockState.getValue((Property)IEProperties.FACING_HORIZONTAL), (Boolean)blockState.getValue((Property)RAILING_LEFT), (Boolean)blockState.getValue((Property)RAILING_RIGHT), collision);
        }
    }
}

