/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonIE;
import blusunrize.immersiveengineering.client.utils.GuiHelper;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.ShelfLogic;
import blusunrize.immersiveengineering.common.gui.ShelfMenu;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ShelfScreen
extends IEContainerScreen<ShelfMenu> {
    private static final ResourceLocation TEXTURE = ShelfScreen.makeTextureLocation("shelf");
    private static final GuiButtonIE.ButtonTexture BUTTON = new GuiButtonIE.ButtonTexture(IEApi.ieLoc("shelf/swap"));
    private static final Component TEXT_SWAP = Component.translatable((String)"gui.immersiveengineering.config.shelf.swap");
    private int playerInvX = 0;
    private int playerInvY = 0;
    private GuiButtonIE swapButton;

    public ShelfScreen(ShelfMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.titleLabelY = 3;
    }

    @Override
    protected void init() {
        this.playerInvX = 88;
        this.imageWidth = 352;
        this.playerInvY = 138;
        this.imageHeight = this.playerInvY + 94;
        super.init();
        this.inventoryLabelY = this.playerInvY + 3;
        this.clearWidgets();
        this.swapButton = (GuiButtonIE)this.addRenderableWidget((GuiEventListener)new GuiButtonIE(this.leftPos + this.playerInvX + 176 + 2, this.topPos + this.playerInvY, 16, 16, (Component)Component.empty(), BUTTON, button -> {
            boolean b = ((ShelfMenu)this.menu).backside.get() == false;
            ((ShelfMenu)this.menu).backside.set(b);
            CompoundTag nbt = new CompoundTag();
            nbt.putBoolean("backside", b);
            this.sendUpdateToServer(nbt);
        }));
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        super.gatherAdditionalTooltips(mouseX, mouseY, addLine, addGray);
        if (this.swapButton.isHovered() && ((ShelfMenu)this.menu).getCarried().isEmpty()) {
            addLine.accept(TEXT_SWAP);
        }
    }

    @Override
    protected void drawBackgroundTexture(GuiGraphics graphics) {
        List<ItemStack> crates = ((ShelfMenu)this.menu).backside.get() != false ? ((ShelfMenu)this.menu).cratesBack.get() : ((ShelfMenu)this.menu).cratesFront.get();
        Map<Item, ShelfLogic.CrateVariant> variants = ShelfLogic.CRATE_VARIANTS.get();
        for (int i = 0; i < crates.size(); ++i) {
            if (crates.get(i).isEmpty()) continue;
            ShelfLogic.CrateVariant variant = variants.get(crates.get(i).getItem());
            int x = i % 2 * 176;
            int y = i / 2 * 69;
            if (variant.color() != -1) {
                Color4 color = Color4.fromRGB(variant.color());
                GuiHelper.colouredBlit(graphics, this.background, this.leftPos + x, this.topPos + y, 0, 176, 69, 0, 94 + variant.screenVOffset(), color.r(), color.g(), color.b(), color.a());
                continue;
            }
            graphics.blit(this.background, this.leftPos + x, this.topPos + y, 0, 94 + variant.screenVOffset(), 176, 69);
        }
        graphics.blit(this.background, this.leftPos + this.playerInvX, this.topPos + this.playerInvY, 0, 0, 176, 94);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        List<ItemStack> crates = ((ShelfMenu)this.menu).backside.get() != false ? ((ShelfMenu)this.menu).cratesBack.get() : ((ShelfMenu)this.menu).cratesFront.get();
        for (int i = 0; i < crates.size(); ++i) {
            if (crates.get(i).isEmpty()) continue;
            int x = i % 2 * 176;
            int y = i / 2 * 69;
            graphics.drawString(this.font, crates.get(i).getHoverName(), x + this.titleLabelX, y + this.titleLabelY, -557004, false);
        }
        graphics.drawString(this.font, this.playerInventoryTitle, this.playerInvX + this.inventoryLabelX, this.inventoryLabelY, -557004, false);
    }
}

