/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import com.sun.management.HotSpotDiagnosticMXBean;
import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.api.windows.PsApi;
import dev.uncandango.alltheleaks.commands.ATLCommands;
import dev.uncandango.alltheleaks.exceptions.ATLIllegalState;
import dev.uncandango.alltheleaks.mixin.Trackable;
import dev.uncandango.alltheleaks.report.ReportManager;
import dev.uncandango.alltheleaks.utils.MemoryStats;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@Issue(modId="minecraft", issueId="Memory Monitor", versionRange="1.20.1", mixins={"main.PlayerMixin", "main.ChunkAccessMixin", "main.LevelMixin", "main.MinecraftServerMixin"})
public class MemoryMonitor {
    private static final boolean EXPLICIT_GC_DISABLED;
    private static final AtomicLong LAST_RUN_GC;
    private static final List<String> CACHED_SUMMARY;
    public static final String DEBUG_MOD_PREFIX;

    public static boolean runExplicitGc() {
        if (!MemoryMonitor.isExplicitGcDisabled()) {
            System.gc();
            if (MemoryStats.ENABLED) {
                PsApi.EmptyWorkingSetOfCurrentProcess();
            }
        } else {
            AllTheLeaks.LOGGER.warn("Tried to run explicit GC but it was disabled.");
            return false;
        }
        LAST_RUN_GC.set(Util.getMillis());
        return true;
    }

    public static void dumpHeap() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            Path path = FMLPaths.getOrCreateGameRelativePath((Path)Path.of("heap_dump/", new String[0])).normalize().toAbsolutePath();
            String filePath = String.valueOf(path) + "/" + LocalDateTime.now().toEpochSecond(ZoneOffset.UTC) + ".hprof";
            mxBean.dumpHeap(filePath, true);
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.error("Error while creating heapdump: {}", (Object)e.getMessage());
        }
    }

    public static List<String> getEventsSummary() {
        int serverStopCount;
        int serverPlayerLogout;
        int noRemovalReasonErrorCount;
        int serverPlayerClone;
        int clientPlayerClone;
        int clientLevelUpdate;
        int worldJoinMultiplayerCount;
        ArrayList<String> lines = new ArrayList<String>();
        int worldJoinSingleplayerCount = EventStatistics.WORLD_JOIN_SINGLEPLAYER.getCount();
        int worldJoinTotal = worldJoinSingleplayerCount + (worldJoinMultiplayerCount = EventStatistics.WORLD_JOIN_MULTIPLAYER.getCount());
        if (worldJoinTotal > 0) {
            lines.add("World join: " + worldJoinTotal);
            lines.add("  Singleplayer: " + worldJoinSingleplayerCount);
            lines.add("  Multiplayer: " + worldJoinMultiplayerCount);
        }
        if ((clientLevelUpdate = EventStatistics.CLIENT_LEVEL_UPDATE.getCount()) > 0) {
            lines.add("Client Level Updates: " + clientLevelUpdate);
        }
        if ((clientPlayerClone = EventStatistics.CLIENT_PLAYER_CLONE.getCount()) > 0) {
            lines.add("Client Player Clone: " + clientPlayerClone);
        }
        if ((serverPlayerClone = EventStatistics.SERVER_PLAYER_CLONE.getCount()) > 0) {
            lines.add("Server Player Clone: " + serverPlayerClone);
        }
        if ((noRemovalReasonErrorCount = ATLIllegalState.TYPE.NO_REMOVAL_REASON.getErrorCount()) > 0) {
            lines.add("  Invalid Cloned Players: " + noRemovalReasonErrorCount);
        }
        if ((serverPlayerLogout = EventStatistics.SERVER_PLAYER_LOGOUT.getCount()) > 0) {
            lines.add("Server Player Logout: " + serverPlayerLogout);
        }
        if ((serverStopCount = EventStatistics.SERVER_STOP.getCount()) > 0) {
            lines.add("Server Stopped: " + serverStopCount);
        }
        return lines;
    }

    public static void logFullSummary(Consumer<String> logger) {
        List<String> events = MemoryMonitor.getEventsSummary();
        logger.accept("Listing events...");
        events.forEach(logger);
        logger.accept("Listing memory leaks so far...");
        MemoryMonitor.getFullSummary("", false).forEach(logger);
    }

    public static String getMemoryStatistics() {
        long base = Statistics.getMinMemoryInMb();
        if (base == 0L) {
            return "Waiting to stabilize [" + Statistics.getStableCount() + "/" + Statistics.getStableThreshold() + "]";
        }
        long current = Statistics.getCurrentMinMemoryInMb();
        long diff = current - base;
        return "B: " + base + "MB / C: " + current + "MB / Diff: +" + diff + "MB";
    }

    public static boolean isExplicitGcDisabled() {
        return EXPLICIT_GC_DISABLED;
    }

    public static long lastRunGc() {
        return LAST_RUN_GC.get();
    }

    public static List<String> getFullSummary(String prefix, boolean padding) {
        ArrayList<String> lines = new ArrayList<String>();
        if (padding) {
            lines.add(" ");
        }
        lines.add(prefix + MemoryMonitor.getMemoryStatistics());
        List<String> formattedSummary = MemoryMonitor.getFormattedSummary(prefix);
        if (formattedSummary.isEmpty()) {
            lines.add(prefix + "No memory leak detected!");
        } else {
            lines.add(prefix + "Memory Leaks detected: (" + String.valueOf(ChatFormatting.GREEN) + "/atl force_refresh" + String.valueOf(ChatFormatting.RESET) + " to update)");
            lines.addAll(formattedSummary);
        }
        return lines;
    }

    public static List<String> getFormattedSummary(String prefix) {
        if (CACHED_SUMMARY.isEmpty() || prefix.isEmpty()) {
            return CACHED_SUMMARY;
        }
        return CACHED_SUMMARY.stream().map(line -> prefix + line).toList();
    }

    public static void updateLeakSummary() {
        CACHED_SUMMARY.clear();
        Trackable.getSummary().forEach((baseClazz, summaryMap) -> {
            if (summaryMap.isEmpty()) {
                return;
            }
            CACHED_SUMMARY.add("| " + baseClazz.getSimpleName() + ":");
            summaryMap.forEach((innerClazz, count) -> {
                Module module = innerClazz.getModule();
                if (module != null) {
                    CACHED_SUMMARY.add("|- " + innerClazz.getSimpleName() + " (" + module.getName() + "): " + count);
                } else {
                    CACHED_SUMMARY.add("|- " + innerClazz.getSimpleName() + ": " + count);
                }
            });
        });
    }

    public static void tooMuchMemoryUsage() {
        double percentUsage = (double)Statistics.getCurrentMinMemoryInMb() / (double)Statistics.getMaxMemoryInMb();
        if (percentUsage > 0.9) {
            CommandSourceStack source = null;
            if (FMLEnvironment.dist.isClient()) {
                LocalPlayer player = Minecraft.getInstance().player;
                if (player != null) {
                    source = player.createCommandSourceStack();
                }
            } else {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    source = server.createCommandSourceStack();
                }
            }
            if (source == null) {
                return;
            }
            source.sendSystemMessage((Component)Component.literal((String)"You reached 90% memory usage, showing leaking objects so far...").withStyle(ChatFormatting.RED));
            source.sendSystemMessage((Component)Component.literal((String)MemoryMonitor.getMemoryStatistics()));
            ATLCommands.checkLeaking(source, false);
            ReportManager.stop("too_much_memory_usage");
        }
    }

    static {
        boolean explicitGcDisabled;
        LAST_RUN_GC = new AtomicLong(Util.getMillis());
        CACHED_SUMMARY = new ArrayList<String>();
        DEBUG_MOD_PREFIX = String.valueOf(ChatFormatting.GREEN) + "[AllTheLeaks] " + String.valueOf(ChatFormatting.RESET);
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            HotSpotDiagnosticMXBean mxBean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", HotSpotDiagnosticMXBean.class);
            explicitGcDisabled = Boolean.parseBoolean(mxBean.getVMOption("DisableExplicitGC").getValue());
        }
        catch (Exception e) {
            AllTheLeaks.LOGGER.error("Error while instancing MXBean: {}", (Object)e.getMessage());
            explicitGcDisabled = true;
        }
        EXPLICIT_GC_DISABLED = explicitGcDisabled;
    }

    public static enum EventStatistics {
        CLIENT_LEVEL_UPDATE(new AtomicInteger()),
        WORLD_JOIN_SINGLEPLAYER(new AtomicInteger()),
        WORLD_JOIN_MULTIPLAYER(new AtomicInteger()),
        CLIENT_PLAYER_CLONE(new AtomicInteger()),
        SERVER_PLAYER_CLONE(new AtomicInteger()),
        SERVER_PLAYER_LOGOUT(new AtomicInteger()),
        SERVER_STOP(new AtomicInteger());

        private final AtomicInteger count;

        private EventStatistics(AtomicInteger count) {
            this.count = count;
        }

        public void increment() {
            this.count.incrementAndGet();
        }

        public int getCount() {
            return this.count.get();
        }
    }

    public static class Statistics {
        private static final long maxMemory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        private static long minMemory = 0L;
        private static long currentMinMemory = 0L;
        private static long currentUsedMemory = 0L;
        private static int stableCount = 0;
        private static final int stableTicksThreshold = 10;

        public static void evaluateMemory() {
            if (FMLEnvironment.dist.isClient() && (Minecraft.getInstance().isPaused() || Minecraft.getInstance().level == null)) {
                return;
            }
            long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (currentUsedMemory > used) {
                if (stableCount < 10) {
                    double diff;
                    double d = diff = currentMinMemory > 0L ? 1.0 - (double)used / (double)currentMinMemory : 1.0;
                    stableCount = Math.abs(diff) > 0.02 ? 0 : ++stableCount;
                }
                currentMinMemory = used;
                if (minMemory == 0L && stableCount >= 10 || currentMinMemory < minMemory) {
                    minMemory = currentMinMemory;
                }
            }
            currentUsedMemory = used;
        }

        public static long getMinMemoryInMb() {
            return minMemory / 1024L / 1024L;
        }

        public static long getStableCount() {
            return stableCount;
        }

        public static long getMaxMemoryInMb() {
            return maxMemory;
        }

        public static long getStableThreshold() {
            return 10L;
        }

        public static void reset() {
            minMemory = 0L;
            stableCount = 0;
        }

        public static long getCurrentMinMemoryInMb() {
            return currentMinMemory / 1024L / 1024L;
        }
    }
}

