/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.items;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.crafting.IComponentsToPreserve;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsbase.api.storage.IStorageModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.data.StorageModuleData;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class StorageModuleItem
extends Item
implements IComponentsToPreserve,
IStorageModuleItem {
    public static final int STORAGE_TIER1 = 0;
    public static final int STORAGE_TIER2 = 1;
    public static final int STORAGE_TIER3 = 2;
    public static final int STORAGE_TIER4 = 3;
    public static final int STORAGE_REMOTE = 6;
    public static final int[] MAXSIZE = new int[]{100, 200, 300, 500, 0, 0, -1};
    private final int tier;
    private final Lazy<TooltipBuilder> tooltipBuilder = Lazy.of(() -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsStringClient), TooltipBuilder.key((String)"message.rftoolsstorage.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isRemoteModule()), TooltipBuilder.parameter((String)"info", stack -> !this.isRemoteModule(), stack -> Integer.toString(this.getMax())), TooltipBuilder.parameter((String)"remoteid", stack -> this.isRemoteModule(), stack -> {
        int id = StorageModuleItem.getData(stack).id();
        if (id != -1) {
            return Integer.toString(id);
        }
        return "<unlinked>";
    }), TooltipBuilder.parameter((String)"uuid", stack -> {
        UUID uuid = StorageModuleItem.getData(stack).uuid();
        if (uuid != null) {
            return uuid.toString();
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"version", stack -> {
        int version = StorageModuleItem.getData(stack).version();
        if (version != -1) {
            return Integer.toString(version);
        }
        return "<unset>";
    }), TooltipBuilder.parameter((String)"items", stack -> !this.isRemoteModule() && this.hasUUID((ItemStack)stack), this::getContentsStringClient)}).infoAdvanced(new InfoLine[]{TooltipBuilder.parameter((String)"advanced", this::getAdvancedInfoClient)}));

    private String getContentsStringClient(ItemStack stack) {
        int cnt = StorageModuleItem.getData(stack).infoAmount();
        if (cnt != -1) {
            return cnt + "/" + this.getMax();
        }
        return "<unknown>";
    }

    public static StorageModuleData getData(ItemStack stack) {
        StorageModuleData data = (StorageModuleData)stack.get((DataComponentType)ModularStorageModule.ITEM_STORAGE_MODULE_DATA.get());
        if (data == null) {
            data = StorageModuleData.DEFAULT;
        }
        return data;
    }

    private String getAdvancedInfoClient(ItemStack stack) {
        StorageInfo storage = this.getStorageClient(stack);
        if (storage != null) {
            String createdBy = storage.createdBy();
            Object info = "";
            info = createdBy != null && !createdBy.isEmpty() ? (String)info + "Created by " + createdBy : (String)info + "Unknown creator";
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date creationTime = new Date(StorageModuleItem.getData(stack).creationTime());
            Date updateTime = new Date(StorageModuleItem.getData(stack).updateTime());
            info = (String)info + ", Creation time " + dateFormat.format(creationTime);
            info = (String)info + ", Update time " + dateFormat.format(updateTime);
            return info;
        }
        return "<unknown>";
    }

    private StorageInfo getStorageClient(ItemStack stack) {
        StorageModuleData data = StorageModuleItem.getData(stack);
        if (data.id() == -1) {
            return null;
        }
        return StorageModuleItem.getStorageInfo(stack);
    }

    @Nonnull
    public static StorageInfo getStorageInfo(ItemStack storageCard) {
        Item item = storageCard.getItem();
        if (item instanceof StorageModuleItem) {
            UUID uuid = StorageModuleItem.getOrCreateUUID(storageCard);
            int version = StorageModuleItem.getVersion(storageCard);
            int size = StorageModuleItem.getSize(storageCard);
            String createdBy = StorageModuleItem.getCreatedBy(storageCard);
            return new StorageInfo(uuid, version, size, createdBy);
        }
        return StorageInfo.EMPTY;
    }

    private boolean isRemoteModule() {
        return this.getMax() == -1;
    }

    private boolean hasUUID(ItemStack stack) {
        UUID uuid = StorageModuleItem.getData(stack).uuid();
        return uuid != null;
    }

    public StorageModuleItem(int tier) {
        super(RFToolsStorage.setup.defaultProperties().stacksTo(1).durability(0));
        this.tier = tier;
    }

    private int getMax() {
        return MAXSIZE[this.tier];
    }

    public void onCraftedBy(@Nonnull ItemStack stack, @Nonnull Level worldIn, @Nonnull Player player) {
        StorageModuleData data = StorageModuleItem.getData(stack);
        String createdBy = data.createdBy();
        if (createdBy != null && !createdBy.isEmpty()) {
            data = data.withCreatedBy(player.getName().getString());
            stack.set((DataComponentType)ModularStorageModule.ITEM_STORAGE_MODULE_DATA.get(), (Object)data);
        }
    }

    public static UUID getOrCreateUUID(ItemStack stack) {
        if (!(stack.getItem() instanceof StorageModuleItem)) {
            throw new RuntimeException("This is not supposed to happen! Needs to be a storage item!");
        }
        StorageModuleData data = StorageModuleItem.getData(stack);
        UUID uuid = data.uuid();
        if (uuid == null) {
            uuid = UUID.randomUUID();
            data = data.withUuid(uuid).withVersion(0);
            stack.set((DataComponentType)ModularStorageModule.ITEM_STORAGE_MODULE_DATA.get(), (Object)data);
        }
        return uuid;
    }

    public static String getCreatedBy(ItemStack storageCard) {
        return StorageModuleItem.getData(storageCard).createdBy();
    }

    public static int getVersion(ItemStack stack) {
        return StorageModuleItem.getData(stack).version();
    }

    public static int getSize(ItemStack storageCard) {
        if (storageCard.getItem() instanceof StorageModuleItem) {
            int tier = ((StorageModuleItem)storageCard.getItem()).tier;
            return MAXSIZE[tier];
        }
        return 0;
    }

    public Collection<DataComponentType<?>> getComponentsToPreserve() {
        return List.of((DataComponentType)ModularStorageModule.ITEM_STORAGE_MODULE_DATA.get());
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Place this module in a storage module tablet to access contents"));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flags) {
        super.appendHoverText(itemStack, context, list, flags);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"storage_module"), itemStack, list, flags);
    }
}

