/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.client;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.GuiTools;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.ImageLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.GuiCraftingGrid;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageConfiguration;
import mcjty.rftoolsstorage.modules.modularstorage.ModularStorageModule;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageContainer;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import mcjty.rftoolsstorage.setup.CommandHandler;
import mcjty.rftoolsstorage.storage.modules.DefaultTypeModule;
import mcjty.rftoolsstorage.storage.modules.TypeModule;
import mcjty.rftoolsstorage.storage.sorters.ItemSorter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity, ModularStorageContainer> {
    public static final int STORAGE_WIDTH = 256;
    public static final String VIEW_LIST = "list";
    public static final String VIEW_COLUMNS = "columns";
    public static final String VIEW_ICONS = "icons";
    private TypeModule typeModule;
    private static final ResourceLocation iconLocationTop = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"textures/gui/modularstorage.png");
    private static final ResourceLocation guiElements = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbase", (String)"textures/gui/guielements.png");
    private WidgetList itemList;
    private TextField filter;
    private ImageChoiceLabel viewMode;
    private ImageChoiceLabel sortMode;
    private ImageChoiceLabel groupMode;
    private Label amountLabel;
    private ToggleButton lockButton;
    private Button cycleButton;
    private Button compactButton;
    private Label warningLabel;
    private final GuiCraftingGrid craftingGrid = new GuiCraftingGrid();

    public GuiModularStorage(ModularStorageContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, ((BaseBlock)ModularStorageModule.MODULAR_STORAGE.block().get()).getManualEntry());
        this.imageWidth = 256;
        double height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.imageHeight = height > 510.0 ? (Integer)ModularStorageConfiguration.height3.get() : (height > 340.0 ? ((Integer)ModularStorageConfiguration.height2.get()).intValue() : ((Integer)ModularStorageConfiguration.height1.get()).intValue());
    }

    public static void register(RegisterMenuScreensEvent event) {
        event.register(ModularStorageModule.CONTAINER_MODULAR_STORAGE.get(), GuiModularStorage::new);
    }

    public void init() {
        super.init();
        this.itemList = ((WidgetList)((WidgetList)Widgets.list((int)5, (int)3, (int)235, (int)(this.imageHeight - 89)).name("items")).noSelectionMode(true).userObject((Object)-1)).leftMargin(0).rowheight(-1);
        Slider slider = ((Slider)Widgets.slider((int)241, (int)3, (int)11, (int)(this.imageHeight - 89)).desiredWidth(11)).vertical().scrollableName("items");
        this.warningLabel = Widgets.label((int)20, (int)20, (int)200, (int)20, (String)"Lock the storage to access the items!");
        this.lockButton = (ToggleButton)((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton().hint(5, this.imageHeight - 23 - 18, 16, 16)).text("L")).name("lock")).event(this::updateSettings).tooltips(new String[]{"Lock/unlock the module slots"});
        this.cycleButton = (Button)((Button)((Button)Widgets.button((int)5, (int)(this.imageHeight - 23), (int)16, (int)16, (String)"C").name("cycle")).channel("cycle")).tooltips(new String[]{"Cycle to the next storage module"});
        Panel modePanel = this.setupModePanel();
        Panel toplevel = (Panel)Widgets.positional().children(new Widget[]{this.itemList, slider, modePanel, this.lockButton, this.cycleButton, this.warningLabel});
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.imageHeight - (Integer)ModularStorageConfiguration.height1.get() + 2);
        if (this.getBE() == null) {
            ImageLabel hideLabel = new ImageLabel();
            hideLabel.hint(4, this.imageHeight - 26 - 54, 20, 55);
            hideLabel.image(guiElements, 32, 32);
            toplevel.children(new Widget[]{hideLabel});
        }
        toplevel.bounds(this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cycle", (source, params) -> this.cycleStorage());
        this.window.event("compact", (source, params) -> this.compact());
        if (((Boolean)ModularStorageConfiguration.autofocusSearch.get()).booleanValue()) {
            this.window.setTextFocus((Widget)this.filter);
        }
        CraftingGridProvider provider = null;
        BlockPos pos = null;
        if (this.getBE() == null) {
            throw new RuntimeException("Should not happen!");
        }
        provider = (CraftingGridProvider)this.getBE();
        pos = this.getBE().getBlockPos();
        this.craftingGrid.initGui(this.minecraft, this, pos, (ResourceKey<Level>)this.getBE().getDimension(), provider, this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.sendServerCommand("rftoolsstorage", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).put(CommandHandler.PARAM_DIMENSION, (Object)this.getBE().getDimension()).build());
    }

    protected void registerWindows(WindowManager mgr) {
        super.registerWindows(mgr);
        mgr.addWindow(this.craftingGrid.getWindow());
    }

    private Panel setupModePanel() {
        this.filter = ((TextField)Widgets.textfield((int)3, (int)3, (int)57, (int)13).tooltips(new String[]{"Name based filter for items"})).event(newText -> this.updateSettings());
        this.viewMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(4, 19, 16, 16)).tooltips(new String[]{"Control how items are shown", "in the view"})).event(newChoice -> this.updateSettings());
        this.viewMode.choice(VIEW_LIST, "Items are shown in a list view", guiElements, 144, 16);
        this.viewMode.choice(VIEW_COLUMNS, "Items are shown in columns", guiElements, 160, 16);
        this.viewMode.choice(VIEW_ICONS, "Items are shown with icons", guiElements, 176, 16);
        this.updateTypeModule();
        this.sortMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(23, 19, 16, 16)).tooltips(new String[]{"Control how items are sorted", "in the view"})).event(newChoice -> this.updateSettings());
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        this.groupMode = ((ImageChoiceLabel)((ImageChoiceLabel)new ImageChoiceLabel().hint(42, 19, 16, 16)).tooltips(new String[]{"If enabled it will show groups", "based on sorting criterium"})).event(newChoice -> this.updateSettings());
        this.groupMode.choice("Off", "Don't show groups", guiElements, 208, 0);
        this.groupMode.choice("On", "Show groups", guiElements, 224, 0);
        this.amountLabel = (Label)((Label)Widgets.label((int)16, (int)40, (int)66, (int)12, (String)"?/?").horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).tooltips(new String[]{"Amount of stacks / maximum amount"});
        this.compactButton = (Button)((Button)((Button)Widgets.button((int)4, (int)39, (int)12, (int)12, (String)"z").name("compact")).channel("compact")).tooltips(new String[]{"Compact equal stacks"});
        ModularStorageTileEntity tileEntity = (ModularStorageTileEntity)this.getBE();
        if (tileEntity != null) {
            this.filter.text((Boolean)ModularStorageConfiguration.clearSearchOnOpen.get() != false ? "" : tileEntity.getFilter());
            this.setViewMode(tileEntity.getViewMode());
            this.setSortMode(tileEntity.getSortMode());
            this.groupMode.setCurrentChoice(tileEntity.isGroupMode() ? 1 : 0);
            this.lockButton.pressed(tileEntity.isLocked());
            this.warningLabel.visible(!tileEntity.isLocked());
            this.itemList.visible(tileEntity.isLocked());
        } else {
            ItemStack itemStack = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        return (Panel)((Panel)((Panel)((Panel)Widgets.positional().hint(24, this.imageHeight - 80, 64, 77)).filledRectThickness(-2)).filledBackground(StyleConfig.colorListBackground)).children(new Widget[]{this.filter, this.viewMode, this.sortMode, this.groupMode, this.amountLabel, this.compactButton});
    }

    private void setSortMode(String sortMode) {
        int idx = this.sortMode.findChoice(sortMode);
        if (idx == -1) {
            this.sortMode.setCurrentChoice(0);
        } else {
            this.sortMode.setCurrentChoice(idx);
        }
    }

    private void setViewMode(String viewMode) {
        int idx = this.viewMode.findChoice(viewMode);
        if (idx == -1) {
            this.viewMode.setCurrentChoice(VIEW_LIST);
        } else {
            this.viewMode.setCurrentChoice(idx);
        }
    }

    private void cycleStorage() {
        if (this.getBE() != null) {
            this.window.sendServerCommand(ModularStorageTileEntity.CMD_CYCLE, TypedMap.EMPTY);
        } else {
            this.sendServerCommand("rftoolsstorage", "cycleStorage");
        }
    }

    private void compact() {
        if (this.getBE() != null) {
            this.window.sendServerCommand(ModularStorageTileEntity.CMD_COMPACT, TypedMap.EMPTY);
        } else {
            this.sendServerCommand("rftoolsstorage", "compact");
        }
    }

    private void updateSettings() {
        ModularStorageTileEntity tileEntity = (ModularStorageTileEntity)this.getBE();
        if (tileEntity != null) {
            tileEntity.setSortMode(this.sortMode.getCurrentChoice());
            tileEntity.setViewMode(this.viewMode.getCurrentChoice());
            tileEntity.setFilter(this.filter.getText());
            tileEntity.setGroupMode(this.groupMode.getCurrentChoiceIndex() == 1);
            tileEntity.setLocked(this.lockButton.isPressed());
            this.warningLabel.visible(!tileEntity.isLocked());
            this.itemList.visible(tileEntity.isLocked());
            this.sendServerCommandTyped(ModularStorageTileEntity.CMD_SETTINGS, TypedMap.builder().put(ModularStorageTileEntity.PARAM_SORTMODE, (Object)this.sortMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_VIEWMODE, (Object)this.viewMode.getCurrentChoice()).put(ModularStorageTileEntity.PARAM_FILTER, (Object)this.filter.getText()).put(ModularStorageTileEntity.PARAM_GROUPMODE, (Object)(this.groupMode.getCurrentChoiceIndex() == 1 ? 1 : 0)).put(ModularStorageTileEntity.PARAM_LOCKED, (Object)this.lockButton.isPressed()).build());
        }
    }

    private Slot findEmptySlot() {
        for (Slot slot : ((ModularStorageContainer)this.menu).slots) {
            if (this.getBE() != null && !(slot instanceof BaseSlot) || slot.hasItem() && slot.getItem().getCount() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean isHovering(@Nonnull Slot slotIn, double x, double y) {
        if (slotIn instanceof BaseSlot && ((BaseSlot)slotIn).getTe() instanceof ModularStorageTileEntity) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex == slotIn.index;
                }
            } else {
                return super.isHovering(slotIn, x, y);
            }
            return false;
        }
        return super.isHovering(slotIn, x, y);
    }

    public Slot findSlot(double x, double y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return ((ModularStorageContainer)this.menu).getSlot(slotIndex);
            }
            return this.findEmptySlot();
        }
        return super.findSlot(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + String.valueOf(o.getClass().getGenericSuperclass())));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        Slot slot;
        boolean r = super.mouseClicked(x, y, button);
        if (button == 1 && (slot = this.findSlot(x, y)) instanceof GhostOutputSlot) {
            if (this.getBE() != null) {
                this.window.sendServerCommand(ModularStorageTileEntity.CMD_CLEARGRID, TypedMap.EMPTY);
            } else {
                this.sendServerCommand("rftoolsstorage", "clearGrid");
            }
        }
        return r;
    }

    private void updateList() {
        int spacing;
        int labelWidth;
        int numcolumns;
        this.itemList.removeChildren();
        if (this.getBE() != null && !((ModularStorageContainer)this.menu).getSlot(0).hasItem()) {
            this.amountLabel.text("(empty)");
            this.compactButton.enabled(false);
            this.cycleButton.enabled(false);
            return;
        }
        this.cycleButton.enabled(this.isTabletWithRemote() || this.isRemote());
        String filterText = this.filter.getText().toLowerCase().trim();
        String view = this.viewMode.getCurrentChoice();
        if (VIEW_LIST.equals(view)) {
            numcolumns = 1;
            labelWidth = 210;
            spacing = 5;
        } else if (VIEW_COLUMNS.equals(view)) {
            numcolumns = 2;
            labelWidth = 86;
            spacing = 5;
        } else {
            numcolumns = 12;
            labelWidth = 0;
            spacing = 3;
        }
        AtomicInteger max = new AtomicInteger();
        ArrayList<Object> items = new ArrayList<Object>();
        ModularStorageTileEntity tileEntity = (ModularStorageTileEntity)this.getBE();
        if (tileEntity != null) {
            IItemHandlerModifiable handler = tileEntity.getItems();
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                String displayName = stack.getHoverName().getString();
                if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
                items.add(Pair.of((Object)stack, (Object)(i + 3)));
            }
            max.set(handler.getSlots());
        }
        this.amountLabel.text(items.size() + "/" + String.valueOf(max));
        this.compactButton.enabled(max.get() > 0);
        int sort = this.getCurrentSortMode();
        boolean dogroups = this.groupMode.getCurrentChoiceIndex() == 1;
        ItemSorter itemSorter = this.typeModule.getSorters().get(sort);
        items.sort(itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        Pair prevItem = null;
        for (Pair pair : items) {
            currentPos = this.addItemToList((ItemStack)pair.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)pair.getValue(), dogroups && (prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)pair)), itemSorter.getGroupName((Pair<ItemStack, Integer>)pair));
            prevItem = pair;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private boolean isRemote() {
        return false;
    }

    private boolean isTabletWithRemote() {
        if (this.getBE() != null) {
            return false;
        }
        ItemStack heldItem = this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND);
        return false;
    }

    private int getCurrentSortMode() {
        this.updateTypeModule();
        String sortName = this.sortMode.getCurrentChoice();
        this.sortMode.clear();
        for (ItemSorter sorter : this.typeModule.getSorters()) {
            this.sortMode.choice(sorter.getName(), sorter.getTooltip(), guiElements, sorter.getU(), sorter.getV());
        }
        int sort = this.sortMode.findChoice(sortName);
        if (sort == -1) {
            sort = 0;
        }
        this.sortMode.setCurrentChoice(sort);
        return sort;
    }

    private void updateTypeModule() {
        ItemStack typeStack;
        this.typeModule = this.getBE() != null ? ((typeStack = ItemStack.EMPTY).isEmpty() || !(typeStack.getItem() instanceof TypeModule) ? new DefaultTypeModule() : (TypeModule)typeStack.getItem()) : new DefaultTypeModule();
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)Widgets.label((String)groupName).color(((Integer)ModularStorageConfiguration.groupForeground.get()).intValue())).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).filledBackground(((Integer)ModularStorageConfiguration.groupBackground.get()).intValue())).desiredHeight(10)).desiredWidth(231);
                itemList.children(new Widget[]{((Panel)new Panel().layout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).desiredHeight(10)).children(new Widget[]{groupLabel})});
            }
            panel = (Panel)((Panel)((Panel)Widgets.horizontal((int)5, (int)spacing).desiredHeight(12)).userObject((Object)-1)).desiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.children(new Widget[]{panel});
        }
        BlockRender blockRender = ((BlockRender)new BlockRender().renderItem((Object)stack).userObject((Object)slot)).offsetX(-1).offsetY(-1);
        panel.children(new Widget[]{blockRender});
        if (labelWidth > 0) {
            String displayName = labelWidth > 100 ? this.typeModule.getLongLabel(stack) : this.typeModule.getShortLabel(stack);
            AbstractWidget label = ((Label)((Label)((Label)Widgets.label((String)displayName).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).desiredWidth(labelWidth)).userObject((Object)new Integer(-1));
            panel.children(new Widget[]{label});
        }
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean rc = false;
        if (!this.window.keyTyped(keyCode, scanCode)) {
            if (keyCode >= 49 && keyCode <= 57) {
                return true;
            }
            rc = super.keyPressed(keyCode, scanCode, modifiers);
        }
        return rc;
    }

    protected void renderBg(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.updateList();
        ModularStorageTileEntity tileEntity = (ModularStorageTileEntity)this.getBE();
        if (tileEntity != null) {
            this.viewMode.setCurrentChoice(tileEntity.getViewMode());
            this.sortMode.setCurrentChoice(tileEntity.getSortMode());
            this.groupMode.setCurrentChoice(tileEntity.isGroupMode() ? 1 : 0);
            String curFilter = tileEntity.getFilter();
            if (!this.filter.getText().equals(curFilter)) {
                this.filter.text(curFilter);
            }
        }
        this.drawWindow(graphics, partialTicks, x, y);
    }

    protected void renderTooltip(@Nonnull GuiGraphics graphics, int x, int y) {
        ModularStorageTileEntity tileEntity;
        Slot slot = this.findSlot(x, y);
        if (slot instanceof SlotItemHandler && !(slot instanceof BaseSlot) && !(slot instanceof GhostOutputSlot) && !(slot instanceof GhostSlot) && (tileEntity = (ModularStorageTileEntity)this.getBE()).isLocked()) {
            graphics.renderTooltip(this.minecraft.font, (Component)ComponentFactory.literal((String)"Unlock to access these slots").withStyle(ChatFormatting.RED), x, y);
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    protected void drawStackTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderLabels(@Nonnull GuiGraphics graphics, int mouseX, int mouseY) {
        ModularStorageTileEntity tileEntity;
        int x = GuiTools.getRelativeX((Screen)this);
        int y = GuiTools.getRelativeY((Screen)this);
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(graphics, tooltips, this.window.getTooltipItems(), x - this.leftPos, y - this.topPos, this.minecraft.font);
        }
        if ((tileEntity = (ModularStorageTileEntity)this.getBE()).isLocked()) {
            int offset = 300;
            graphics.blit(guiElements, 5, this.imageHeight - 79, offset, 96.0f, 96.0f, 16, 16, 256, 256);
            graphics.blit(guiElements, 5, this.imageHeight - 61, offset, 96.0f, 96.0f, 16, 16, 256, 256);
        }
        super.renderLabels(graphics, mouseX, mouseY);
        this.warningLabel.visible(!tileEntity.isLocked());
        this.itemList.visible(tileEntity.isLocked());
        this.lockButton.pressed(tileEntity.isLocked());
    }

    protected void drawWindow(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.drawWindow(graphics, partialTicks, x, y);
        this.craftingGrid.draw(graphics);
    }
}

