/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat.jei;

import java.util.List;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolsbase.api.compat.JEIRecipeAcceptor;
import mcjty.rftoolsbase.modules.tablet.items.TabletItem;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketSendRecipe(List<ItemStack> stacks, BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsstorage", (String)"sendrecipe");
    public static final CustomPacketPayload.Type<PacketSendRecipe> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketSendRecipe> CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, PacketSendRecipe::stacks, (StreamCodec)BlockPos.STREAM_CODEC, PacketSendRecipe::pos, PacketSendRecipe::new);

    public static PacketSendRecipe create(ItemStackList items, BlockPos pos) {
        return new PacketSendRecipe((List<ItemStack>)items, pos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            if (this.pos == null) {
                ItemStack mainhand = player.getMainHandItem();
                if (!mainhand.isEmpty() && mainhand.getItem() instanceof TabletItem && player.containerMenu instanceof StorageScannerContainer) {
                    StorageScannerContainer storageScannerContainer = (StorageScannerContainer)player.containerMenu;
                }
            } else {
                BlockEntity te = world.getBlockEntity(this.pos);
                if (te instanceof JEIRecipeAcceptor) {
                    JEIRecipeAcceptor acceptor = (JEIRecipeAcceptor)te;
                    acceptor.setGridContents(this.stacks);
                }
            }
        });
    }
}

