/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.animation;

import com.iafenvoy.uranus.ServerHelper;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationEvents;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.network.AnimationPayload;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.ArrayUtils;

public enum AnimationHandler {
    INSTANCE;


    public <T extends Entity> void sendAnimationMessage(T entity, Animation animation) {
        if (entity.level().isClientSide) {
            return;
        }
        ((IAnimatedEntity)entity).setAnimation(animation);
        ServerHelper.sendToAll(new AnimationPayload(entity.getId(), ArrayUtils.indexOf((Object[])((IAnimatedEntity)entity).getAnimations(), (Object)animation)));
    }

    public <T extends Entity> void updateAnimations(T entity) {
        if (((IAnimatedEntity)entity).getAnimation() == null) {
            ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
        } else if (((IAnimatedEntity)entity).getAnimation() != IAnimatedEntity.NO_ANIMATION) {
            if (((IAnimatedEntity)entity).getAnimationTick() == 0 && !AnimationEvents.START.invoker().onStart((IAnimatedEntity)entity, ((IAnimatedEntity)entity).getAnimation())) {
                this.sendAnimationMessage(entity, ((IAnimatedEntity)entity).getAnimation());
            }
            if (((IAnimatedEntity)entity).getAnimationTick() < ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(((IAnimatedEntity)entity).getAnimationTick() + 1);
                AnimationEvents.TICK.invoker().onTick((IAnimatedEntity)entity, ((IAnimatedEntity)entity).getAnimation(), ((IAnimatedEntity)entity).getAnimationTick());
            }
            if (((IAnimatedEntity)entity).getAnimationTick() == ((IAnimatedEntity)entity).getAnimation().getDuration()) {
                ((IAnimatedEntity)entity).setAnimationTick(0);
                ((IAnimatedEntity)entity).setAnimation(IAnimatedEntity.NO_ANIMATION);
            }
        }
    }
}

