/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.datagen;

import com.buuz135.sushigocrafting.api.IFoodIngredient;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.block.plant.CustomCropBlock;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class SushiItemTagsProvider
extends ItemTagsProvider {
    public SushiItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> completableFuture, CompletableFuture<TagsProvider.TagLookup<Block>> lookupCompletableFuture, @Nullable ExistingFileHelper existingFileHelper) {
        super(packOutput, completableFuture, lookupCompletableFuture, "sushigocrafting", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider provider) {
        this.copy(BlockTags.LOGS, ItemTags.LOGS);
        this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
        for (CustomCropBlock customCropBlock : new CustomCropBlock[]{(CustomCropBlock)((Object)SushiContent.Blocks.RICE_CROP.get()), (CustomCropBlock)((Object)SushiContent.Blocks.CUCUMBER_CROP.get()), (CustomCropBlock)((Object)SushiContent.Blocks.SOY_CROP.get()), (CustomCropBlock)((Object)SushiContent.Blocks.WASABI_CROP.get()), (CustomCropBlock)((Object)SushiContent.Blocks.SESAME_CROP.get())}) {
            this.tag(Tags.Items.SEEDS).add((Object)customCropBlock.getBaseSeedId().asItem());
            this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("seeds/" + this.getNameFor(BuiltInRegistries.ITEM.getKey((Object)customCropBlock.getBaseSeedId().asItem()).getPath()))))).add((Object)customCropBlock.getBaseSeedId().asItem());
        }
        for (CustomCropBlock customCropBlock : new Item[]{(Item)SushiContent.Items.RICE.get(), (Item)SushiContent.Items.CUCUMBER.get(), (Item)SushiContent.Items.SOY_BEAN.get(), (Item)SushiContent.Items.WASABI_ROOT.get(), (Item)SushiContent.Items.SESAME_SEED.get()}) {
            this.tag(Tags.Items.CROPS).add((Object)customCropBlock);
            this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("crops/" + this.getNameFor(BuiltInRegistries.ITEM.getKey((Object)customCropBlock).getPath()))))).add((Object)customCropBlock.asItem());
        }
        this.tag(ItemTags.FISHES).add((Object)((Item)SushiContent.Items.RAW_TUNA.get())).add((Object)((Item)SushiContent.Items.SHRIMP.get()));
        this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"raw_fishes"))).add((Object)Items.SALMON).add((Object)((Item)SushiContent.Items.SHRIMP.get())).add((Object)((Item)SushiContent.Items.RAW_TUNA.get()));
        for (CustomCropBlock customCropBlock : new Item[]{Items.SALMON, (Item)SushiContent.Items.SHRIMP.get(), (Item)SushiContent.Items.RAW_TUNA.get()}) {
            this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("raw_fishes/" + (((Object)((Object)customCropBlock)).equals(SushiContent.Items.RAW_TUNA.get()) ? "tuna" : BuiltInRegistries.ITEM.getKey((Object)customCropBlock).getPath()))))).add((Object)customCropBlock.asItem());
        }
        this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"fruits"))).add((Object)((Item)SushiContent.Items.AVOCADO.get()));
        this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"fruits/avocado"))).add((Object)((Item)SushiContent.Items.AVOCADO.get()));
        this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"tools/knives"))).add((Object)((Item)SushiContent.Items.KNIFE_CLEAVER.get()));
        for (Map.Entry entry : FoodHelper.REGISTERED.entrySet()) {
            for (DeferredHolder deferredHolder : (List)entry.getValue()) {
                for (IFoodIngredient foodIngredient : ((FoodItem)((Object)deferredHolder.get())).getIngredientList()) {
                    if (foodIngredient.isEmpty()) continue;
                    this.tag(ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"diet", (String)foodIngredient.getDietType().name().toLowerCase(Locale.ROOT)))).add((Object)((Item)deferredHolder.get()));
                }
            }
        }
    }

    public String getNameFor(String name) {
        if (name.equals("soy_bean")) {
            return "soybean";
        }
        return name.replaceAll("_seeds", "");
    }
}

