/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting.block.machinery;

import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.hrznstudio.titanium.block.RotatableBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CoolerBoxBlock
extends RotatableBlock<CoolerBoxTile> {
    public static VoxelShape SHAPE_NORTH = Block.box((double)0.5, (double)0.0, (double)1.5, (double)15.5, (double)14.0, (double)14.5);
    public static VoxelShape SHAPE_EAST = Block.box((double)1.5, (double)0.0, (double)0.5, (double)14.5, (double)14.0, (double)15.5);

    public CoolerBoxBlock() {
        super("cooler_box", BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE), CoolerBoxTile.class);
    }

    public BlockEntityType.BlockEntitySupplier<?> getTileEntityFactory() {
        return CoolerBoxTile::new;
    }

    public Item asItem() {
        return Item.byBlock((Block)this);
    }

    @Nonnull
    public RotatableBlock.RotationType getRotationType() {
        return RotatableBlock.RotationType.FOUR_WAY;
    }

    @Nonnull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NORTH : SHAPE_EAST;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)RotatableBlock.FACING_HORIZONTAL);
        return direction == Direction.NORTH || direction == Direction.SOUTH ? SHAPE_NORTH : SHAPE_EAST;
    }

    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder builder) {
        NonNullList stacks = NonNullList.create();
        ItemStack stack = new ItemStack((ItemLike)this);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof CoolerBoxTile) {
            CoolerBoxTile coolerBoxTile = (CoolerBoxTile)blockEntity;
            this.copyTo(coolerBoxTile, stack);
        }
        stacks.add((Object)stack);
        return stacks;
    }

    public NonNullList<ItemStack> getDynamicDrops(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        return NonNullList.create();
    }

    protected void copyTo(CoolerBoxTile tile, ItemStack stack) {
        if (!tile.isEmpty()) {
            stack.set(SushiDataComponent.TILE, (Object)tile.saveWithoutMetadata((HolderLookup.Provider)tile.getLevel().registryAccess()));
        }
    }

    protected void copyFrom(ItemStack stack, CoolerBoxTile tile) {
        if (stack.has(SushiDataComponent.TILE)) {
            tile.loadAdditional((CompoundTag)stack.get(SushiDataComponent.TILE), (HolderLookup.Provider)tile.getLevel().registryAccess());
            tile.markForUpdate();
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof CoolerBoxTile) {
            CoolerBoxTile tile = (CoolerBoxTile)entity;
            this.copyFrom(stack, tile);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag tileData;
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (stack.has(SushiDataComponent.TILE) && (tileData = (CompoundTag)stack.get(SushiDataComponent.TILE)).contains("input")) {
            NonNullList nonnulllist = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
            ContainerHelper.loadAllItems((CompoundTag)tileData.getCompound("input"), (NonNullList)nonnulllist, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : nonnulllist) {
                if (itemstack.isEmpty()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                MutableComponent iformattabletextcomponent = itemstack.getHoverName().copy();
                iformattabletextcomponent.append(" x").append(String.valueOf(itemstack.getCount())).withStyle(ChatFormatting.DARK_AQUA);
                tooltip.add((Component)iformattabletextcomponent);
            }
            if (j - i > 0) {
                tooltip.add((Component)Component.translatable((String)"container.shulkerBox.more", (Object[])new Object[]{j - i}).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_AQUA}));
            }
        }
    }
}

