/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.sushigocrafting;

import com.buuz135.sushigocrafting.api.IFoodType;
import com.buuz135.sushigocrafting.api.impl.FoodAPI;
import com.buuz135.sushigocrafting.api.impl.FoodHelper;
import com.buuz135.sushigocrafting.client.ClientProxy;
import com.buuz135.sushigocrafting.datagen.SushiBlockTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiBlockstateProvider;
import com.buuz135.sushigocrafting.datagen.SushiDataMapProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiItemTagsProvider;
import com.buuz135.sushigocrafting.datagen.SushiLangProvider;
import com.buuz135.sushigocrafting.datagen.SushiLootTableProvider;
import com.buuz135.sushigocrafting.datagen.SushiModelProvider;
import com.buuz135.sushigocrafting.datagen.SushiRecipeProvider;
import com.buuz135.sushigocrafting.item.AmountItem;
import com.buuz135.sushigocrafting.item.FoodItem;
import com.buuz135.sushigocrafting.item.SushiDataComponent;
import com.buuz135.sushigocrafting.network.CapabilitySyncMessage;
import com.buuz135.sushigocrafting.proxy.SushiContent;
import com.buuz135.sushigocrafting.tile.machinery.CoolerBoxTile;
import com.buuz135.sushigocrafting.tile.machinery.CuttingBoardTile;
import com.buuz135.sushigocrafting.tile.machinery.FermentationBarrelTile;
import com.buuz135.sushigocrafting.tile.machinery.RiceCookerTile;
import com.buuz135.sushigocrafting.tile.machinery.RollerTile;
import com.buuz135.sushigocrafting.world.PistonCrafting;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.module.ModuleController;
import com.hrznstudio.titanium.nbthandler.NBTManager;
import com.hrznstudio.titanium.network.NetworkHandler;
import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import com.hrznstudio.titanium.reward.RewardManager;
import com.hrznstudio.titanium.tab.TitaniumTab;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sushigocrafting")
public class SushiGoCrafting
extends ModuleController {
    public static final String MOD_ID = "sushigocrafting";
    public static final TitaniumTab TAB = new TitaniumTab(ResourceLocation.fromNamespaceAndPath((String)"sushigocrafting", (String)"main"));
    public static NetworkHandler NETWORK = new NetworkHandler("sushigocrafting");
    public static Logger LOGGER = LogManager.getLogger((String)"sushigocrafting");

    public SushiGoCrafting(Dist dist, IEventBus modBus, ModContainer container) {
        super(container);
        SushiContent.Blocks.REGISTRY.register(modBus);
        SushiContent.Items.REGISTRY.register(modBus);
        SushiContent.TileEntities.REGISTRY.register(modBus);
        SushiContent.Effects.REGISTRY.register(modBus);
        SushiContent.EntityTypes.REGISTRY.register(modBus);
        SushiContent.LootSerializers.REGISTRY.register(modBus);
        SushiContent.RecipeSerializers.REGISTRY.register(modBus);
        SushiContent.RecipeTypes.REGISTRY.register(modBus);
        SushiDataComponent.REGISTRY.register(modBus);
        SushiContent.AttachmentTypes.REGISTRY.register(modBus);
        if (dist == Dist.CLIENT) {
            ClientProxy.register();
            EventManager.mod(FMLClientSetupEvent.class).process(fmlClientSetupEvent -> new ClientProxy().fmlClient((FMLClientSetupEvent)fmlClientSetupEvent)).subscribe();
        }
        EventManager.mod(FMLCommonSetupEvent.class).process(this::fmlCommon).subscribe();
        EventManager.mod(GatherDataEvent.class).process(this::dataGen).subscribe();
        NBTManager.getInstance().scanTileClassForAnnotations(RollerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(RiceCookerTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CuttingBoardTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(CoolerBoxTile.class);
        NBTManager.getInstance().scanTileClassForAnnotations(FermentationBarrelTile.class);
        new PistonCrafting();
        EventManager.mod(EntityAttributeCreationEvent.class).process(entityAttributeCreationEvent -> {
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.TUNA.get(), AbstractFish.createAttributes().build());
            entityAttributeCreationEvent.put((EntityType)SushiContent.EntityTypes.SHRIMP.get(), AbstractFish.createAttributes().build());
        }).subscribe();
        EventManager.forge(LivingDropsEvent.class).filter(livingDropsEvent -> livingDropsEvent.getEntity() instanceof AbstractFish).process(livingDropsEvent -> {
            if (livingDropsEvent.getEntity().level().getRandom().nextInt(10) <= 2) {
                livingDropsEvent.getDrops().add(new ItemEntity(livingDropsEvent.getEntity().level(), livingDropsEvent.getEntity().getX(), livingDropsEvent.getEntity().getY(), livingDropsEvent.getEntity().getZ(), ((AmountItem)((Object)((Object)SushiContent.Items.TOBIKO.get()))).random(null, livingDropsEvent.getEntity().level())));
            }
        }).subscribe();
        RewardGiver giver = RewardManager.get().getGiver(UUID.fromString("d28b7061-fb92-4064-90fb-7e02b95a72a6"), "Buuz135");
        try {
            giver.addReward(new Reward(ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"back"), new URL("https://raw.githubusercontent.com/Buuz135/Industrial-Foregoing/master/contributors.json"), () -> dist2 -> {}, new String[]{"salmon", "tuna"}));
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
        EventManager.mod(RegisterSpawnPlacementsEvent.class).process(event -> {
            event.register((EntityType)SushiContent.EntityTypes.SHRIMP.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
            event.register((EntityType)SushiContent.EntityTypes.TUNA.get(), SpawnPlacementTypes.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::checkMobSpawnRules, RegisterSpawnPlacementsEvent.Operation.OR);
        }).subscribe();
        EventManager.mod(RegisterCapabilitiesEvent.class).process(event -> {
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.COOLER_BOX.value(), ActiveTile::getItemHandler);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.CUTTING_BOARD.value(), ActiveTile::getItemHandler);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.FERMENTATION_BARREL.value(), ActiveTile::getItemHandler);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.RICE_COOKER.value(), ActiveTile::getItemHandler);
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.ROLLER.value(), ActiveTile::getItemHandler);
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.FERMENTATION_BARREL.value(), ActiveTile::getFluidHandler);
            event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)SushiContent.TileEntities.RICE_COOKER.value(), ActiveTile::getFluidHandler);
        }).subscribe();
    }

    protected void initModules() {
        FoodAPI.get();
        FoodAPI.get().init();
        for (IFoodType value : FoodAPI.get().getFoodTypes()) {
            FoodHelper.generateFood(value).forEach(item -> {
                Supplier<Item> supplier = () -> {
                    FoodItem foodItem = new FoodItem(new Item.Properties(), item.getFoodType());
                    foodItem.getIngredientList().addAll(item.getFoodIngredients());
                    return foodItem;
                };
                FoodHelper.REGISTERED.computeIfAbsent(value.getName(), s -> new ArrayList()).add(SushiContent.item(FoodHelper.getName(item), supplier));
            });
        }
        this.addCreativeTab("main", () -> new ItemStack((ItemLike)((DeferredHolder)FoodHelper.REGISTERED.values().stream().flatMap(Collection::stream).findFirst().get()).get()), MOD_ID, TAB);
    }

    public void fmlCommon(FMLCommonSetupEvent event) {
    }

    public void dataGen(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new SushiModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiBlockstateProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiItemModelProvider(event.getGenerator(), MOD_ID, event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiLangProvider(event.getGenerator(), MOD_ID, "en_us"));
        SushiBlockTagsProvider provider = new SushiBlockTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper());
        event.getGenerator().addProvider(true, (DataProvider)provider);
        event.getGenerator().addProvider(true, (DataProvider)new SushiItemTagsProvider(event.getGenerator().getPackOutput(), event.getLookupProvider(), provider.contentsGetter(), event.getExistingFileHelper()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiLootTableProvider(event.getGenerator(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiRecipeProvider(event.getGenerator(), event.getLookupProvider()));
        event.getGenerator().addProvider(true, (DataProvider)new SushiDataMapProvider(event.getGenerator().getPackOutput(), event.getLookupProvider()));
    }

    static {
        NeoForgeMod.enableMilkFluid();
        NETWORK.registerMessage("capability_sync", CapabilitySyncMessage.class);
    }
}

