/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import invtweaks.InvTweaksMod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Category {
    private final List<String> spec;
    private final List<List<Predicate<ItemStack>>> compiledSpec = new ArrayList<List<Predicate<ItemStack>>>();

    public Category(List<String> spec) {
        this.spec = spec;
        for (String subspec : spec) {
            ArrayList compiledSubspec = new ArrayList();
            for (String clause : subspec.split("\\s*;\\s*")) {
                Category.compileClause(clause).ifPresent(compiledSubspec::add);
            }
            this.compiledSpec.add(compiledSubspec);
        }
    }

    public Category(String ... spec) {
        this(Arrays.asList(spec));
    }

    private static Optional<Predicate<ItemStack>> compileClause(String clause) {
        if (clause.startsWith("!")) {
            return Category.compileClause(clause.substring(1)).map(Predicate::negate);
        }
        String[] parts = clause.split(":", 2);
        if (parts[0].equals("/tag")) {
            TagKey itemKey = TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)parts[1]));
            TagKey blockKey = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)parts[1]));
            return Optional.of(stack -> {
                BlockItem blockItem;
                Item patt0$temp;
                return stack.is(itemKey) || (patt0$temp = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock().defaultBlockState().is(blockKey);
            });
        }
        if (parts[0].equals("/instanceof") || parts[0].equals("/class")) {
            try {
                Class<?> clazz = Class.forName(parts[1]);
                if (parts[0].equals("/instanceof")) {
                    return Optional.of(st -> clazz.isInstance(st.getItem()));
                }
                return Optional.of(st -> st.getItem().getClass().equals(clazz));
            }
            catch (ClassNotFoundException e) {
                InvTweaksMod.LOGGER.warn("Class not found! Ignoring clause");
                return Optional.empty();
            }
        }
        if (parts[0].equals("/isFood")) {
            return Optional.of(stack -> stack.getFoodProperties(null) != null);
        }
        try {
            return Optional.of(st -> Objects.equals(BuiltInRegistries.ITEM.getKey((Object)st.getItem()), ResourceLocation.parse((String)clause)));
        }
        catch (ResourceLocationException e) {
            InvTweaksMod.LOGGER.warn("Invalid item resource location found.");
            return Optional.empty();
        }
    }

    public int checkStack(ItemStack stack) {
        return IntStream.range(0, this.compiledSpec.size()).filter(idx -> this.compiledSpec.get(idx).stream().allMatch(pr -> pr.test(stack))).findFirst().orElse(-1);
    }

    public CommentedConfig toConfig(String catName) {
        CommentedConfig result = CommentedConfig.inMemory();
        result.set("name", (Object)catName);
        result.set("spec", this.spec);
        return result;
    }
}

