/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.registry;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.util.GeneratorCreator;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.GeneratorUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class GeneratorRegistry {
    public static Map<ResourceLocation, GeneratorObject> generators = new LinkedHashMap<ResourceLocation, GeneratorObject>();

    public static void discoverGenerators() {
        try {
            GeneratorRegistry.discoverGeneratorFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discoverGeneratorFiles() throws IOException {
        File lockFile = new File(GeneratorUtil.LOCK_FILE.toString(), "defaults.lock");
        if (!lockFile.exists()) {
            FileUtils.write((File)lockFile, (CharSequence)"This lock file means the standard generator have already been added and you can now do your own custom stuff to them.", (Charset)StandardCharsets.UTF_8);
            GeneratorRegistry.setupDefaultFiles("/data/generatorgalore/generator", Paths.get(GeneratorUtil.GENERATORS.toString(), new String[0]), true);
        } else {
            GeneratorRegistry.setupDefaultFiles("/data/generatorgalore/generator", Paths.get(GeneratorUtil.GENERATORS.toString(), new String[0]), false);
        }
        File[] files = GeneratorUtil.GENERATORS.toFile().listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".json"));
        if (files == null) {
            return;
        }
        for (File file : files) {
            InputStreamReader reader = null;
            ResourceLocation id = null;
            GeneratorObject generator = null;
            try {
                JsonParser parser = new JsonParser();
                reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
                JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
                String name = file.getName().replace(".json", "");
                id = ResourceLocation.fromNamespaceAndPath((String)"generatorgalore", (String)name);
                if (json.has("requiredMod") && !ModList.get().isLoaded(json.get("requiredMod").getAsString())) {
                    IOUtils.closeQuietly((Reader)reader);
                    continue;
                }
                generator = GeneratorCreator.create(id, json);
                reader.close();
                IOUtils.closeQuietly((Reader)reader);
            }
            catch (Exception e) {
                GeneratorGalore.LOGGER.error("An error occurred while creating generator with id {}", id, (Object)e);
            }
            finally {
                IOUtils.closeQuietly(reader);
            }
            if (generator != null) {
                GeneratorGalore.LOGGER.debug("adding generator " + String.valueOf(generator.getId()));
                generators.put(generator.getId(), generator);
                continue;
            }
            GeneratorGalore.LOGGER.error("failed to load generator " + String.valueOf(id));
        }
    }

    public static void setupDefaultFiles(String dataPath, Path targetPath, boolean override) {
        List<Path> roots = List.of(ModList.get().getModFileById("generatorgalore").getFile().getFilePath());
        if (override) {
            GeneratorGalore.LOGGER.debug("[Generator Galore] Pulling defaults from: " + String.valueOf(roots));
        }
        if (roots.isEmpty()) {
            throw new RuntimeException("Failed to load defaults.");
        }
        for (Path modRoot : roots) {
            GeneratorRegistry.setupDefaultFiles(dataPath, targetPath, modRoot, override);
        }
    }

    public static void setupDefaultFiles(String dataPath, Path targetPath, Path modPath, boolean override) {
        GeneratorGalore.LOGGER.debug("Loading generator files from " + dataPath + " to " + String.valueOf(targetPath));
        if (Files.isRegularFile(modPath, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(modPath);){
                Path path = fileSystem.getPath(dataPath, new String[0]);
                if (Files.exists(path, new LinkOption[0])) {
                    GeneratorRegistry.copyFiles(path, targetPath, override);
                }
            }
            catch (IOException e) {
                GeneratorGalore.LOGGER.error("Could not load source {}!!", (Object)modPath);
                GeneratorGalore.LOGGER.error(e.getLocalizedMessage());
            }
        } else if (Files.isDirectory(modPath, new LinkOption[0])) {
            GeneratorRegistry.copyFiles(Paths.get(modPath.toString(), dataPath), targetPath, override);
        }
    }

    private static void copyFiles(Path source, Path targetPath, boolean override) {
        try (Stream<Path> sourceStream = Files.walk(source, new FileVisitOption[0]);){
            sourceStream.filter(f -> f.getFileName().toString().endsWith(".json")).forEach(path -> {
                block4: {
                    try {
                        if (override) {
                            Files.copy(path, Paths.get(targetPath.toString(), path.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
                        } else {
                            Files.copy(path, Paths.get(targetPath.toString(), path.getFileName().toString()), new CopyOption[0]);
                        }
                    }
                    catch (IOException e) {
                        if (!override) break block4;
                        GeneratorGalore.LOGGER.error("Could not copy file: {}, Target: {}", path, (Object)targetPath);
                    }
                }
            });
        }
        catch (IOException e) {
            GeneratorGalore.LOGGER.error("Could not stream source files: {}", (Object)source);
            GeneratorGalore.LOGGER.error(e.getLocalizedMessage());
        }
    }
}

