/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.render.RenderConfiguration;
import com.supermartijn642.core.render.RenderStateConfiguration;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.formations.tools.FormationsLevelData;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4f;

public class StructureVoidHighlighter {
    private static final int HIGHLIGHT_RANGE = 15;
    private static final BlockShape HIGHLIGHT_SHAPE = BlockShape.fullCube().shrink(0.2);
    private static final RenderConfiguration QUADS = RenderConfiguration.create((String)"supermartijn642corelib", (String)"quads", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (RenderConfiguration.PrimitiveType)RenderConfiguration.PrimitiveType.QUADS, (int)256, (boolean)false, (boolean)true, (RenderStateConfiguration)RenderStateConfiguration.builder().useShader(GameRenderer::getPositionColorShader).useTranslucentTransparency().disableTexture().disableCulling().useLessThanOrEqualDepthTest().disableDepthMask().build());

    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(StructureVoidHighlighter::highlightStructureVoidBlocks);
    }

    private static void highlightStructureVoidBlocks(RenderWorldEvent e) {
        if (!FormationsLevelData.CLIENT.isDevMode()) {
            return;
        }
        Player player = ClientUtils.getPlayer();
        Item mainItem = player.getItemInHand(InteractionHand.MAIN_HAND).getItem();
        Item secondaryItem = player.getItemInHand(InteractionHand.OFF_HAND).getItem();
        if (!(mainItem instanceof BlockItem && ((BlockItem)mainItem).getBlock() instanceof StructureVoidBlock || secondaryItem instanceof BlockItem && ((BlockItem)secondaryItem).getBlock() instanceof StructureVoidBlock)) {
            return;
        }
        e.getPoseStack().pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
        Level level = ClientUtils.getWorld();
        BlockPos center = player.getOnPos();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        MultiBufferSource.BufferSource bufferSource = RenderUtils.getMainBufferSource();
        VertexConsumer builder = QUADS.begin((MultiBufferSource)bufferSource);
        for (int xOffset = -15; xOffset <= 15; ++xOffset) {
            for (int yOffset = -15; yOffset <= 15; ++yOffset) {
                for (int zOffset = -15; zOffset <= 15; ++zOffset) {
                    pos.set(center.getX() + xOffset, center.getY() + yOffset, center.getZ() + zOffset);
                    if (!(level.getBlockState((BlockPos)pos).getBlock() instanceof StructureVoidBlock)) continue;
                    e.getPoseStack().pushPose();
                    e.getPoseStack().translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                    StructureVoidHighlighter.renderShapeSides(e.getPoseStack(), builder, HIGHLIGHT_SHAPE, 0.9607843f, 0.3647059f, 0.81960785f, 0.9f);
                    e.getPoseStack().popPose();
                }
            }
        }
        QUADS.end(bufferSource);
        e.getPoseStack().popPose();
    }

    public static void renderShapeSides(PoseStack poseStack, VertexConsumer builder, BlockShape shape, float red, float green, float blue, float alpha) {
        Matrix4f matrix = poseStack.last().pose();
        shape.forEachBox(box -> {
            float minX = (float)box.minX;
            float maxX = (float)box.maxX;
            float minY = (float)box.minY;
            float maxY = (float)box.maxY;
            float minZ = (float)box.minZ;
            float maxZ = (float)box.maxZ;
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, minY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, minX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, minZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, maxY, maxZ).setColor(red, green, blue, alpha);
            builder.addVertex(matrix, maxX, minY, maxZ).setColor(red, green, blue, alpha);
        });
    }
}

